/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.AbstractMailboxSelectionRequest;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.base.SelectedMailboxImpl;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxNotFoundException;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.util.FetchGroupImpl;

abstract class AbstractSelectionProcessor<M extends AbstractMailboxSelectionRequest>
extends AbstractMailboxProcessor<M> {
    private final Flags flags = new Flags();
    final StatusResponseFactory statusResponseFactory;
    private final boolean openReadOnly;

    public AbstractSelectionProcessor(Class<M> acceptableClass, ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, boolean openReadOnly) {
        super(acceptableClass, next, mailboxManager, statusResponseFactory);
        this.statusResponseFactory = statusResponseFactory;
        this.openReadOnly = openReadOnly;
        this.flags.add(Flags.Flag.ANSWERED);
        this.flags.add(Flags.Flag.DELETED);
        this.flags.add(Flags.Flag.DRAFT);
        this.flags.add(Flags.Flag.FLAGGED);
        this.flags.add(Flags.Flag.SEEN);
    }

    @Override
    protected void doProcess(AbstractMailboxSelectionRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        try {
            MailboxPath fullMailboxPath = this.buildFullPath(session, mailboxName);
            MessageManager.MetaData metaData = this.selectMailbox(fullMailboxPath, session);
            this.respond(tag, command, session, metaData, responder);
            SearchResUtil.resetSavedSequenceSet((ImapSession)session);
        }
        catch (MailboxNotFoundException e) {
            session.getLog().debug("Select failed", (Throwable)e);
            responder.respond((ImapResponseMessage)this.statusResponseFactory.taggedNo(tag, command, HumanReadableText.FAILURE_NO_SUCH_MAILBOX));
        }
        catch (MailboxException e) {
            session.getLog().debug("Select failed", (Throwable)e);
            this.no(command, tag, responder, HumanReadableText.SELECT);
        }
    }

    private void respond(String tag, ImapCommand command, ImapSession session, MessageManager.MetaData metaData, ImapProcessor.Responder responder) throws MailboxException {
        SelectedMailbox selected = session.getSelected();
        this.flags(responder, selected);
        this.exists(responder, metaData);
        this.recent(responder, selected);
        this.uidValidity(responder, metaData);
        this.unseen(responder, metaData, selected);
        this.permanentFlags(responder, metaData, selected);
        this.uidNext(responder, metaData);
        this.taggedOk(responder, tag, command, metaData);
    }

    private void uidNext(ImapProcessor.Responder responder, MessageManager.MetaData metaData) throws MailboxException {
        long uid = metaData.getUidNext();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UIDNEXT, StatusResponse.ResponseCode.uidNext((long)uid));
        responder.respond((ImapResponseMessage)untaggedOk);
    }

    private void taggedOk(ImapProcessor.Responder responder, String tag, ImapCommand command, MessageManager.MetaData metaData) {
        boolean writeable = metaData.isWriteable() && !this.openReadOnly;
        StatusResponse.ResponseCode code = writeable ? StatusResponse.ResponseCode.readWrite() : StatusResponse.ResponseCode.readOnly();
        StatusResponse taggedOk = this.statusResponseFactory.taggedOk(tag, command, HumanReadableText.SELECT, code);
        responder.respond((ImapResponseMessage)taggedOk);
    }

    private void unseen(ImapProcessor.Responder responder, MessageManager.MetaData metaData, SelectedMailbox selected) throws MailboxException {
        Long firstUnseen = metaData.getFirstUnseen();
        if (firstUnseen != null) {
            long unseenUid = firstUnseen;
            int msn = selected.msn(unseenUid);
            if (msn == -1) {
                throw new MailboxException("No message found with uid " + unseenUid);
            }
            StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.unseen((long)msn), StatusResponse.ResponseCode.unseen((int)msn));
            responder.respond((ImapResponseMessage)untaggedOk);
        }
    }

    private void uidValidity(ImapProcessor.Responder responder, MessageManager.MetaData metaData) throws MailboxException {
        long uidValidity = metaData.getUidValidity();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UID_VALIDITY, StatusResponse.ResponseCode.uidValidity((long)uidValidity));
        responder.respond((ImapResponseMessage)untaggedOk);
    }

    private void recent(ImapProcessor.Responder responder, SelectedMailbox selected) {
        int recentCount = selected.recentCount();
        RecentResponse recentResponse = new RecentResponse(recentCount);
        responder.respond((ImapResponseMessage)recentResponse);
    }

    private void exists(ImapProcessor.Responder responder, MessageManager.MetaData metaData) throws MailboxException {
        long messageCount = metaData.getMessageCount();
        ExistsResponse existsResponse = new ExistsResponse(messageCount);
        responder.respond((ImapResponseMessage)existsResponse);
    }

    private MessageManager.MetaData selectMailbox(MailboxPath mailboxPath, ImapSession session) throws MailboxException {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession((ImapSession)session);
        MessageManager mailbox = mailboxManager.getMailbox(mailboxPath, mailboxSession);
        SelectedMailbox currentMailbox = session.getSelected();
        SelectedMailbox sessionMailbox = currentMailbox == null || !currentMailbox.getPath().equals((Object)mailboxPath) ? this.createNewSelectedMailbox(mailbox, mailboxSession, session, mailboxPath) : currentMailbox;
        MessageManager.MetaData metaData = mailbox.getMetaData(!this.openReadOnly, mailboxSession, MessageManager.MetaData.FetchGroup.FIRST_UNSEEN);
        this.addRecent(metaData, sessionMailbox);
        return metaData;
    }

    private SelectedMailbox createNewSelectedMailbox(MessageManager mailbox, MailboxSession mailboxSession, ImapSession session, MailboxPath path) throws MailboxException {
        Iterator messages = mailbox.getMessages(MessageRange.all(), FetchGroupImpl.MINIMAL, mailboxSession);
        Flags applicableFlags = new Flags(this.flags);
        ArrayList<Long> uids = new ArrayList<Long>();
        while (messages.hasNext()) {
            MessageResult mr = (MessageResult)messages.next();
            applicableFlags.add(mr.getFlags());
            uids.add(mr.getUid());
        }
        applicableFlags.remove(Flags.Flag.RECENT);
        SelectedMailboxImpl sessionMailbox = new SelectedMailboxImpl(this.getMailboxManager(), uids.iterator(), applicableFlags, session, path);
        session.selected((SelectedMailbox)sessionMailbox);
        return sessionMailbox;
    }

    private void addRecent(MessageManager.MetaData metaData, SelectedMailbox sessionMailbox) throws MailboxException {
        List recentUids = metaData.getRecent();
        for (int i = 0; i < recentUids.size(); ++i) {
            long uid = (Long)recentUids.get(i);
            sessionMailbox.addRecent(uid);
        }
    }
}

