/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.List;
import org.apache.james.imap.api.message.response.ImapResponseMessage;

public class NamespaceResponse
implements ImapResponseMessage {
    private final List<Namespace> personal;
    private final List<Namespace> users;
    private final List<Namespace> shared;

    public NamespaceResponse(List<Namespace> personal, List<Namespace> users, List<Namespace> shared) {
        this.personal = personal;
        this.users = users;
        this.shared = shared;
    }

    public List<Namespace> getPersonal() {
        return this.personal;
    }

    public List<Namespace> getShared() {
        return this.shared;
    }

    public List<Namespace> getUsers() {
        return this.users;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.personal == null ? 0 : ((Object)this.personal).hashCode());
        result = 31 * result + (this.shared == null ? 0 : ((Object)this.shared).hashCode());
        result = 31 * result + (this.users == null ? 0 : ((Object)this.users).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceResponse other = (NamespaceResponse)obj;
        if (this.personal == null ? other.personal != null : !((Object)this.personal).equals(other.personal)) {
            return false;
        }
        if (this.shared == null ? other.shared != null : !((Object)this.shared).equals(other.shared)) {
            return false;
        }
        return !(this.users == null ? other.users != null : !((Object)this.users).equals(other.users));
    }

    public String toString() {
        return "NamespaceResponse [personal = " + this.personal + " " + "users = " + this.users + " " + "shared = " + this.shared + " " + " ]";
    }

    public static final class Namespace {
        private final String prefix;
        private final char delimiter;

        public Namespace(String prefix, char delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.delimiter;
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Namespace other = (Namespace)obj;
            if (this.delimiter != other.delimiter) {
                return false;
            }
            return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
        }

        public String toString() {
            return "Namespace [prefix=" + this.prefix + ", delim=" + this.delimiter + "]";
        }
    }
}

