/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.EolInputStream;
import org.apache.james.imap.decode.base.FixedLengthInputStream;

public class ImapRequestStreamLineReader
extends ImapRequestLineReader {
    private InputStream input;
    private OutputStream output;

    public ImapRequestStreamLineReader(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            int next = -1;
            try {
                next = this.input.read();
            }
            catch (IOException e) {
                throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Error reading from stream.", e);
            }
            if (next == -1) {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected end of stream.");
            }
            this.nextSeen = true;
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    @Override
    public InputStream read(int size, boolean extraCRLF) throws DecodingException {
        this.nextSeen = false;
        this.nextChar = '\u0000';
        FixedLengthInputStream in = new FixedLengthInputStream(this.input, size);
        if (extraCRLF) {
            return new EolInputStream(this, in);
        }
        return in;
    }

    @Override
    protected void commandContinuationRequest() throws DecodingException {
        try {
            this.output.write(43);
            this.output.write(13);
            this.output.write(10);
            this.output.flush();
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Unexpected exception in sending command continuation request.", e);
        }
    }
}

