/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.clamav;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.DurationParser;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClamAVScan
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVScan.class);
    private static final int DEFAULT_PORT = 3310;
    private static final int DEFAULT_MAX_PINGS = 2;
    private static final int DEFAULT_PING_INTERVAL_MILLI = 10000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLI = 5000;
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final String FOUND_STRING = "FOUND";
    protected static final AttributeName INFECTED_MAIL_ATTRIBUTE_NAME = AttributeName.of((String)"org.apache.james.infected");
    protected static final String INFECTED_HEADER_NAME = "X-MessageIsInfected";
    private boolean debug;
    private String host;
    private int port;
    private int maxPings;
    private int pingIntervalMilli;
    private int socketTimeoutMilli;
    private int streamBufferSize;
    private InetAddress[] addresses;
    private int nextAddressIndex;

    public String getMailetInfo() {
        return "Antivirus Check using ClamAV (CLAMD)";
    }

    protected Set<String> getAllowedInitParameters() {
        return ImmutableSet.of((Object)"debug", (Object)"host", (Object)"port", (Object)"maxPings", (Object)"pingIntervalMilli", (Object)"streamBufferSize", (Object[])new String[0]);
    }

    protected void initDebug() {
        String debugParam = this.getInitParameter("debug");
        this.debug = Boolean.parseBoolean(debugParam);
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected void initHost() throws UnknownHostException {
        this.setHost(this.getInitParameter("host"));
        if (this.isDebug()) {
            LOGGER.debug("host: {}", (Object)this.getHost());
        }
    }

    public String getHost() {
        return this.host;
    }

    private void setHost(String host) throws UnknownHostException {
        this.host = host;
        this.setAddresses(InetAddress.getAllByName(host));
        this.nextAddressIndex = 0;
    }

    protected void initPort() {
        String portParam = this.getInitParameter("port");
        this.setPort(portParam == null ? 3310 : Integer.parseInt(portParam));
        if (this.isDebug()) {
            LOGGER.debug("port: {}", (Object)this.getPort());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void initMaxPings() {
        String maxPingsParam = this.getInitParameter("maxPings");
        this.setMaxPings(maxPingsParam == null ? 2 : Integer.parseInt(maxPingsParam));
        if (this.isDebug()) {
            LOGGER.debug("maxPings: {}", (Object)this.getMaxPings());
        }
    }

    public int getMaxPings() {
        return this.maxPings;
    }

    public void setMaxPings(int maxPings) {
        this.maxPings = maxPings;
    }

    protected void initPingIntervalMilli() {
        this.setPingIntervalMilli(Optional.ofNullable(this.getInitParameter("pingIntervalMilli")).map(string -> (int)DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.MILLIS).toMillis()).orElse(10000));
        if (this.isDebug()) {
            LOGGER.debug("pingIntervalMilli: {}", (Object)this.getPingIntervalMilli());
        }
    }

    protected void initSocketTimeout() {
        this.socketTimeoutMilli = Optional.ofNullable(this.getInitParameter("socketTimeout")).map(string -> (int)DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.MILLIS).toMillis()).orElse(5000);
    }

    public int getPingIntervalMilli() {
        return this.pingIntervalMilli;
    }

    public void setPingIntervalMilli(int pingIntervalMilli) {
        this.pingIntervalMilli = pingIntervalMilli;
    }

    protected void initStreamBufferSize() {
        String streamBufferSizeParam = this.getInitParameter("streamBufferSize");
        this.setStreamBufferSize(streamBufferSizeParam == null ? 8192 : Integer.parseInt(streamBufferSizeParam));
        if (this.isDebug()) {
            LOGGER.debug("streamBufferSize: {}", (Object)this.getStreamBufferSize());
        }
    }

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public void setStreamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
    }

    protected InetAddress getAddresses(int index) {
        return this.addresses[index];
    }

    protected InetAddress[] getAddresses() {
        return this.addresses;
    }

    protected void setAddresses(InetAddress[] addresses) {
        this.addresses = addresses;
    }

    protected synchronized InetAddress getNextAddress() {
        InetAddress address = this.getAddresses(this.nextAddressIndex);
        ++this.nextAddressIndex;
        if (this.nextAddressIndex >= this.getAddressesCount()) {
            this.nextAddressIndex = 0;
        }
        return address;
    }

    public int getAddressesCount() {
        return this.getAddresses().length;
    }

    protected Socket getClamdSocket() throws ConnectException {
        HashSet<InetAddress> usedAddresses = new HashSet<InetAddress>(this.getAddressesCount());
        while (true) {
            if (usedAddresses.size() >= this.getAddressesCount()) {
                String logText = "Unable to connect to CLAMD. All addresses failed.";
                LOGGER.debug("{} Giving up.", (Object)logText);
                throw new ConnectException(logText);
            }
            InetAddress address = this.getNextAddress();
            if (!usedAddresses.add(address)) continue;
            try {
                return new Socket(address, this.getPort());
            }
            catch (IOException ioe) {
                LOGGER.error("Exception caught acquiring main socket to CLAMD on {} on port {}: {}", new Object[]{address, this.getPort(), ioe.getMessage()});
                this.getNextAddress();
                continue;
            }
            break;
        }
    }

    public void init() throws MessagingException {
        this.checkInitParameters(this.getAllowedInitParameters());
        try {
            this.initDebug();
            if (this.isDebug()) {
                LOGGER.debug("Initializing");
            }
            this.initHost();
            this.initPort();
            this.initMaxPings();
            this.initPingIntervalMilli();
            this.initSocketTimeout();
            this.initStreamBufferSize();
            if (this.getMaxPings() > 0) {
                this.ping();
            }
        }
        catch (ConnectException ce) {
            LOGGER.error("ConnectException caught {}", (Object)ce.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Exception thrown", (Throwable)e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getAttribute(INFECTED_MAIL_ATTRIBUTE_NAME).isPresent()) {
            return;
        }
        MimeMessage mimeMessage = mail.getMessage();
        if (mimeMessage == null) {
            LOGGER.debug("Null MimeMessage. Will send to ghost");
            mail.setState("ghost");
            return;
        }
        try {
            if (this.hasVirus((InputStream)new MimeMessageInputStream(mimeMessage))) {
                AuditTrail.entry().protocol("mailetcontainer").action("ClamAVScan").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"infected", (Object)"true"))).log("Mail scanned with ClamAV.");
                LOGGER.info("Detected mail {} containing virus, adding infected header/attribute.", (Object)mail);
                mail.setAttribute(this.makeInfectedAttribute(true));
                mimeMessage.setHeader(INFECTED_HEADER_NAME, "true");
            } else {
                AuditTrail.entry().protocol("mailetcontainer").action("ClamAVScan").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"infected", (Object)"false"))).log("Mail scanned with ClamAV.");
                mail.setAttribute(this.makeInfectedAttribute(false));
                mimeMessage.setHeader(INFECTED_HEADER_NAME, "false");
            }
            this.saveChanges(mimeMessage);
        }
        catch (IOException ex) {
            LOGGER.error("Exception caught calling CLAMD: {}", (Object)ex.getMessage());
        }
    }

    private Attribute makeInfectedAttribute(boolean value) {
        return new Attribute(INFECTED_MAIL_ATTRIBUTE_NAME, AttributeValue.of((Boolean)value));
    }

    protected void ping() throws Exception {
        for (int i = 0; i < this.getAddressesCount(); ++i) {
            this.ping(this.getAddresses(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping(InetAddress address) throws Exception {
        Socket socket = null;
        int ping = 1;
        while (true) {
            if (this.isDebug()) {
                LOGGER.debug("Trial #{}/{} - creating socket connected to {} on port {}", new Object[]{ping, this.getMaxPings(), address, this.getPort()});
            }
            try {
                socket = new Socket(address, this.getPort());
            }
            catch (ConnectException ce) {
                LOGGER.debug("Trial #{}/{} - exception caught while creating socket connected to {} on port {}", new Object[]{ping, this.getMaxPings(), address, this.getPort(), ce});
                if (++ping > this.getMaxPings()) break;
                LOGGER.debug("Waiting {} milliseconds before retrying ...", (Object)this.getPingIntervalMilli());
                Thread.sleep(this.getPingIntervalMilli());
                continue;
            }
            break;
        }
        if (socket == null) {
            throw new ConnectException("maxPings exceeded: " + this.getMaxPings() + ". Giving up. The clamd daemon seems not to be running");
        }
        try {
            String answer;
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.US_ASCII));
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            LOGGER.debug("Sending: \"PING\" to {} ...", (Object)address);
            writer.println("PING");
            writer.flush();
            boolean pongReceived = false;
            while ((answer = reader.readLine()) != null) {
                answer = answer.trim();
                LOGGER.debug("Received: \"{}\"", (Object)answer);
                if (!(answer = answer.trim()).equals("PONG")) continue;
                pongReceived = true;
            }
            reader.close();
            writer.close();
            if (!pongReceived) {
                throw new ConnectException("Bad answer from \"PING\" probe: expecting \"PONG\"");
            }
        }
        finally {
            socket.close();
        }
    }

    protected final void saveChanges(MimeMessage message) throws MessagingException {
        String messageId = message.getMessageID();
        message.saveChanges();
        if (messageId != null) {
            message.setHeader("Message-ID", messageId);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean hasVirus(InputStream mimeMessage) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean replyContainsFound(String reply) {
        return reply.contains(FOUND_STRING);
    }
}

