/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.redis;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.ThreadFactoryProvider;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.apache.james.backends.redis.ClusterRedisConfiguration;
import org.apache.james.backends.redis.MasterReplicaRedisConfiguration;
import org.apache.james.backends.redis.RedisConfiguration;
import org.apache.james.backends.redis.SSLConfiguration;
import org.apache.james.backends.redis.SentinelRedisConfiguration;
import org.apache.james.backends.redis.StandaloneRedisConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.util.concurrent.NamedThreadFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)\u0011\u0007\u0001C\u0001e!91\t\u0001b\u0001\n\u0013!\u0005BB)\u0001A\u0003%Q\tC\u0004S\u0001\t\u0007I\u0011A*\t\ra\u0003\u0001\u0015!\u0003U\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u00159\b\u0001\"\u0003y\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002@\u0001!\t!!\u0011\u0003%I+G-[:DY&,g\u000e\u001e$bGR|'/\u001f\u0006\u0003%M\tQA]3eSNT!\u0001F\u000b\u0002\u0011\t\f7m[3oINT!AF\f\u0002\u000b)\fW.Z:\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u000bM&dWmU=ti\u0016l\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\r\t\u0007/\u001b\u0006\u0003SU\t!BZ5mKNL8\u000f^3n\u0013\tYcE\u0001\u0006GS2,7+_:uK6\f!C]3eSN\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011afL\u0007\u0002#%\u0011\u0001'\u0005\u0002\u0013%\u0016$\u0017n]\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004gQ*\u0004C\u0001\u0018\u0001\u0011\u0015\u00193\u00011\u0001%\u0011\u0015a3\u00011\u0001.Q\t\u0019q\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u00051\u0011N\u001c6fGRT\u0011\u0001P\u0001\bU\u0006\\\u0017M\u001d;b\u0013\tq\u0014HA\u0005TS:<G.\u001a;p]\"\u00121\u0001\u0011\t\u0003q\u0005K!AQ\u001d\u0003\r%s'.Z2u\u0003U!\bN]3bI\u001a\u000b7\r^8ssB\u0013xN^5eKJ,\u0012!\u0012\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0001B]3t_V\u00148-\u001a\u0006\u0003\u0015.\u000bAaY8sK*\u0011A*T\u0001\bY\u0016$H/^2f\u0015\u0005q\u0015AA5p\u0013\t\u0001vIA\u000bUQJ,\u0017\r\u001a$bGR|'/\u001f)s_ZLG-\u001a:\u0002-QD'/Z1e\r\u0006\u001cGo\u001c:z!J|g/\u001b3fe\u0002\naB]1x%\u0016$\u0017n]\"mS\u0016tG/F\u0001U!\t)f+D\u0001J\u0013\t9\u0016JA\nBEN$(/Y2u%\u0016$\u0017n]\"mS\u0016tG/A\bsC^\u0014V\rZ5t\u00072LWM\u001c;!\u0003Y\u0019'/Z1uKN#\u0018M\u001c3bY>tWm\u00117jK:$HCA._!\t)F,\u0003\u0002^\u0013\nY!+\u001a3jg\u000ec\u0017.\u001a8u\u0011\u0015y\u0006\u00021\u0001a\u0003q\u0019H/\u00198eC2|g.\u001a*fI&\u001c8i\u001c8gS\u001e,(/\u0019;j_:\u0004\"AL1\n\u0005\t\f\"\u0001H*uC:$\u0017\r\\8oKJ+G-[:D_:4\u0017nZ;sCRLwN\\\u0001\u0014GJ,\u0017\r^3DYV\u001cH/\u001a:DY&,g\u000e\u001e\u000b\u0003K.\u0004\"AZ5\u000e\u0003\u001dT!\u0001[%\u0002\u000f\rdWo\u001d;fe&\u0011!n\u001a\u0002\u0013%\u0016$\u0017n]\"mkN$XM]\"mS\u0016tG\u000fC\u0003m\u0013\u0001\u0007Q.A\rdYV\u001cH/\u001a:SK\u0012L7oQ8oM&<WO]1uS>t\u0007C\u0001\u0018o\u0013\ty\u0017CA\rDYV\u001cH/\u001a:SK\u0012L7oQ8oM&<WO]1uS>t\u0017!G2sK\u0006$X-T1ti\u0016\u0014(+\u001a9mS\u000e\f7\t\\5f]R$\"a\u0017:\t\u000bMT\u0001\u0019\u0001;\u0002?5\f7\u000f^3s%\u0016\u0004H.[2b%\u0016$\u0017n]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002/k&\u0011a/\u0005\u0002 \u001b\u0006\u001cH/\u001a:SKBd\u0017nY1SK\u0012L7oQ8oM&<WO]1uS>t\u0017\u0001F2sK\u0006$XmU3oi&tW\r\\\"mS\u0016tG\u000f\u0006\u0002\\s\")!p\u0003a\u0001w\u0006Q2/\u001a8uS:,GNU3eSN\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011a\u0006`\u0005\u0003{F\u0011!dU3oi&tW\r\u001c*fI&\u001c8i\u001c8gS\u001e,(/\u0019;j_:\f\u0011c\u0019:fCR,'+\u001a3jg\u000ec\u0017.\u001a8u)\u0015Y\u0016\u0011AA\u0002\u0011\u0015aC\u00021\u0001.\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000f\tQ\"\\1zE\u0016\u0014V\rZ5t+JL\u0007#\u0002\u0010\u0002\n\u00055\u0011bAA\u0006?\t1q\n\u001d;j_:\u00042!VA\b\u0013\r\t\t\"\u0013\u0002\t%\u0016$\u0017n]+S\u0013\u0006)2M]3bi\u0016\u001cE.[3oiJ+7o\\;sG\u0016\u001cH\u0003BA\f\u0003;\u00012ARA\r\u0013\r\tYb\u0012\u0002\u0010\u00072LWM\u001c;SKN|WO]2fg\")A&\u0004a\u0001[\u0005\u00192M]3bi\u0016\u001cE.[3oi>\u0003H/[8ogR1\u00111EA\u0015\u0003g\u00012!VA\u0013\u0013\r\t9#\u0013\u0002\u000e\u00072LWM\u001c;PaRLwN\\:\t\u000f\u0005-b\u00021\u0001\u0002.\u00051Qo]3T'2\u00032AHA\u0018\u0013\r\t\td\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t)D\u0004a\u0001\u0003o\tQ#\\1z\u0005\u0016\u001c6\u000bT\"p]\u001aLw-\u001e:bi&|g\u000eE\u0003\u001f\u0003\u0013\tI\u0004E\u0002/\u0003wI1!!\u0010\u0012\u0005A\u00196\u000bT\"p]\u001aLw-\u001e:bi&|g.A\u0003dY>\u001cX\r\u0006\u0002\u0002DA\u0019a$!\u0012\n\u0007\u0005\u001dsD\u0001\u0003V]&$\bfA\b\u0002LA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Rm\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)&a\u0014\u0003\u0015A\u0013X\rR3tiJ|\u0017\u0010")
public class RedisClientFactory {
    private final FileSystem fileSystem;
    private final ThreadFactoryProvider threadFactoryProvider;
    private final AbstractRedisClient rawRedisClient;

    private ThreadFactoryProvider threadFactoryProvider() {
        return this.threadFactoryProvider;
    }

    public AbstractRedisClient rawRedisClient() {
        return this.rawRedisClient;
    }

    private RedisClient createStandaloneClient(StandaloneRedisConfiguration standaloneRedisConfiguration) {
        return this.createRedisClient(standaloneRedisConfiguration, (Option<RedisURI>)new Some((Object)standaloneRedisConfiguration.redisURI()));
    }

    private RedisClusterClient createClusterClient(ClusterRedisConfiguration clusterRedisConfiguration) {
        RedisClusterClient redisClient = RedisClusterClient.create((ClientResources)this.createClientResources(clusterRedisConfiguration), (Iterable)CollectionConverters$.MODULE$.SeqHasAsJava(clusterRedisConfiguration.redisURI()).asJava());
        redisClient.setOptions(ClusterClientOptions.builder((ClientOptions)this.createClientOptions(clusterRedisConfiguration.useSSL(), clusterRedisConfiguration.mayBeSSLConfiguration())).build());
        return redisClient;
    }

    private RedisClient createMasterReplicaClient(MasterReplicaRedisConfiguration masterReplicaRedisConfiguration) {
        return this.createRedisClient(masterReplicaRedisConfiguration, (Option<RedisURI>)None$.MODULE$);
    }

    private RedisClient createSentinelClient(SentinelRedisConfiguration sentinelRedisConfiguration) {
        return this.createRedisClient(sentinelRedisConfiguration, (Option<RedisURI>)new Some((Object)sentinelRedisConfiguration.redisURI()));
    }

    private RedisClient createRedisClient(RedisConfiguration redisConfiguration, Option<RedisURI> maybeRedisUri) {
        RedisClient redisClient = (RedisClient)maybeRedisUri.map((Function1 & Serializable)redisUri -> RedisClient.create((ClientResources)this.createClientResources(redisConfiguration), (RedisURI)redisUri)).getOrElse((Function0 & Serializable)() -> RedisClient.create((ClientResources)this.createClientResources(redisConfiguration)));
        redisClient.setOptions(this.createClientOptions(redisConfiguration.useSSL(), redisConfiguration.mayBeSSLConfiguration()));
        return redisClient;
    }

    private ClientResources createClientResources(RedisConfiguration redisConfiguration) {
        ClientResources.Builder resourceBuilder = ClientResources.builder().threadFactoryProvider(this.threadFactoryProvider());
        redisConfiguration.ioThreads().foreach((Function1 & Serializable)value -> resourceBuilder.ioThreadPoolSize(BoxesRunTime.unboxToInt((Object)value)));
        redisConfiguration.workerThreads().foreach((Function1 & Serializable)value -> resourceBuilder.computationThreadPoolSize(BoxesRunTime.unboxToInt((Object)value)));
        return resourceBuilder.build();
    }

    private ClientOptions createClientOptions(boolean useSSL, Option<SSLConfiguration> mayBeSSLConfiguration) {
        ClientOptions.Builder clientOptionsBuilder;
        block0: {
            clientOptionsBuilder = ClientOptions.builder();
            clientOptionsBuilder.timeoutOptions(TimeoutOptions.enabled());
            if (!useSSL) break block0;
            mayBeSSLConfiguration.foreach((Function1 & Serializable)sslConfig -> {
                RedisClientFactory.$anonfun$createClientOptions$1(this, clientOptionsBuilder, sslConfig);
                return BoxedUnit.UNIT;
            });
        }
        return clientOptionsBuilder.build();
    }

    @PreDestroy
    public void close() {
        Mono.fromCompletionStage((CompletionStage)this.rawRedisClient().shutdownAsync()).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    public static final /* synthetic */ void $anonfun$createClientOptions$1(RedisClientFactory $this, ClientOptions.Builder clientOptionsBuilder$1, SSLConfiguration sslConfig) {
        if (!sslConfig.ignoreCertificateCheck()) {
            sslConfig.maybeKeyStore().foreach((Function1 & Serializable)redisKeyStore -> {
                SslOptions sslOptions = SslOptions.builder().jdkSslProvider().keystore($this.fileSystem.getFile(redisKeyStore.keyStoreFilePath()), redisKeyStore.keyStorePassword().toCharArray()).build();
                return clientOptionsBuilder$1.sslOptions(sslOptions);
            });
            return;
        }
    }

    @Singleton
    @Inject
    public RedisClientFactory(FileSystem fileSystem, RedisConfiguration redisConfiguration) {
        RedisClient redisClient;
        this.fileSystem = fileSystem;
        this.threadFactoryProvider = poolName -> NamedThreadFactory.withName((String)("redis-driver-" + poolName));
        RedisConfiguration redisConfiguration2 = redisConfiguration;
        if (redisConfiguration2 instanceof StandaloneRedisConfiguration) {
            StandaloneRedisConfiguration standaloneRedisConfiguration = (StandaloneRedisConfiguration)redisConfiguration2;
            redisClient = this.createStandaloneClient(standaloneRedisConfiguration);
        } else if (redisConfiguration2 instanceof MasterReplicaRedisConfiguration) {
            MasterReplicaRedisConfiguration masterReplicaRedisConfiguration = (MasterReplicaRedisConfiguration)redisConfiguration2;
            redisClient = this.createMasterReplicaClient(masterReplicaRedisConfiguration);
        } else if (redisConfiguration2 instanceof ClusterRedisConfiguration) {
            ClusterRedisConfiguration clusterRedisConfiguration = (ClusterRedisConfiguration)redisConfiguration2;
            redisClient = this.createClusterClient(clusterRedisConfiguration);
        } else if (redisConfiguration2 instanceof SentinelRedisConfiguration) {
            SentinelRedisConfiguration sentinelRedisConfiguration = (SentinelRedisConfiguration)redisConfiguration2;
            redisClient = this.createSentinelClient(sentinelRedisConfiguration);
        } else {
            throw new MatchError((Object)redisConfiguration2);
        }
        this.rawRedisClient = redisClient;
    }
}

