/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedList;
import java.util.Map;
import org.apache.jackrabbit.vault.packaging.impl.DefaultPackageProperties;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.spi.GenericMetaInfDataValidator;
import org.apache.jackrabbit.vault.validation.spi.PropertiesValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;

public final class AdvancedPropertiesValidator
implements GenericMetaInfDataValidator {
    protected static final String MESSAGE_INVALID_PROPERTIES_XML = "Invalid properties.xml";
    static final Path PROPERTIES_XML_PATH = Paths.get("vault", new String[0]).resolve("properties.xml");
    private final Map<String, PropertiesValidator> propertiesValidators = new HashMap<String, PropertiesValidator>();
    private final ValidationMessageSeverity severity;

    public AdvancedPropertiesValidator(ValidationMessageSeverity severity) {
        this.severity = severity;
    }

    public void setPropertiesValidators(Map<String, PropertiesValidator> propertiesValidators) {
        this.propertiesValidators.putAll(propertiesValidators);
    }

    @Override
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    public Collection<ValidationMessage> validateMetaInfData(@NotNull InputStream input, @NotNull Path filePath) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        try {
            DefaultPackageProperties properties = DefaultPackageProperties.fromInputStream(input);
            for (Map.Entry<String, PropertiesValidator> entry : this.propertiesValidators.entrySet()) {
                messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Validating with validator " + entry.getKey() + "..."));
                Collection<ValidationMessage> propertiesValidatorMessages = entry.getValue().validate(properties);
                if (propertiesValidatorMessages == null) continue;
                messages.addAll(ValidationViolation.wrapMessages(entry.getKey(), propertiesValidatorMessages, null, null, null, 0, 0));
            }
        }
        catch (InvalidPropertiesFormatException e) {
            messages.add(new ValidationMessage(this.severity, MESSAGE_INVALID_PROPERTIES_XML, e));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read from input stream " + filePath, e);
        }
        return messages;
    }

    @Override
    public boolean shouldValidateMetaInfData(@NotNull Path filePath) {
        return PROPERTIES_XML_PATH.equals(filePath);
    }
}

