/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.context;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.jackrabbit.vault.validation.context.DependencyResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDependencyResolver
implements DependencyResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractDependencyResolver.class);
    public static final String MAVEN_REPOSITORY_SCHEME = "maven";
    private final Collection<PackageInfo> packageInfoCache;

    protected AbstractDependencyResolver() {
        this.packageInfoCache = new LinkedList<PackageInfo>();
    }

    protected AbstractDependencyResolver(@NotNull Collection<PackageInfo> packageInfoCache) {
        this.packageInfoCache = new LinkedList<PackageInfo>(packageInfoCache);
    }

    @Override
    @NotNull
    public Collection<PackageInfo> resolvePackageInfo(@NotNull Dependency[] dependencies, @NotNull Map<PackageId, URI> dependencyLocations) throws IOException {
        LinkedList<PackageInfo> packageInfos = new LinkedList<PackageInfo>();
        for (Dependency dependency : dependencies) {
            PackageInfo packageInfo = null;
            for (PackageInfo packageInfo2 : this.packageInfoCache) {
                if (!dependency.matches(packageInfo2.getId())) continue;
                log.debug("Dependency is already resolved from project dependencies: {}", (Object)dependency);
                packageInfo = packageInfo2;
            }
            if (packageInfo == null) {
                for (Map.Entry entry : dependencyLocations.entrySet()) {
                    if (!dependency.matches((PackageId)entry.getKey())) continue;
                    packageInfo = this.resolvePackageInfo(MavenCoordinates.parse((URI)entry.getValue()));
                }
            }
            if (packageInfo == null) {
                packageInfo = this.resolvePackageInfo(dependency);
            }
            if (packageInfo == null) continue;
            packageInfos.add(packageInfo);
            if (!this.packageInfoCache.contains(packageInfo)) continue;
            this.packageInfoCache.add(packageInfo);
        }
        return packageInfos;
    }

    @Nullable
    protected PackageInfo resolvePackageInfo(@NotNull Dependency dependency) throws IOException {
        String groupId = dependency.getGroup();
        String artifactId = dependency.getName();
        PackageInfo info = null;
        if (dependency.getRange().isLowInclusive()) {
            info = this.resolvePackageInfo(new MavenCoordinates(groupId, artifactId, dependency.getRange().getLow().toString()));
        }
        if (info == null && dependency.getRange().isHighInclusive()) {
            info = this.resolvePackageInfo(new MavenCoordinates(groupId, artifactId, dependency.getRange().getHigh().toString()));
        }
        if (info == null && VersionRange.INFINITE.equals((Object)dependency.getRange())) {
            info = this.resolvePackageInfo(new MavenCoordinates(groupId, artifactId, "LATEST"));
        }
        if (info == null) {
            return null;
        }
        return info;
    }

    @Nullable
    public abstract PackageInfo resolvePackageInfo(@NotNull MavenCoordinates var1) throws IOException;

    public static final class MavenCoordinates {
        @NotNull
        private final String groupId;
        @NotNull
        private final String artifactId;
        @NotNull
        private final String version;
        @NotNull
        private final String packaging;
        @Nullable
        private final String classifier;
        private static final String DEFAULT_PACKAGING = "zip";

        public MavenCoordinates(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            this(groupId, artifactId, version, DEFAULT_PACKAGING, null);
        }

        public MavenCoordinates(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String packaging, String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.packaging = packaging;
            this.classifier = classifier;
        }

        @Nullable
        public static MavenCoordinates parse(URI uri) {
            if (!AbstractDependencyResolver.MAVEN_REPOSITORY_SCHEME.equals(uri.getScheme())) {
                return null;
            }
            if (!uri.isOpaque()) {
                throw new IllegalArgumentException("Only opaque Maven URIs are supported");
            }
            String[] parts = uri.getSchemeSpecificPart().split(":");
            if (parts.length < 3) {
                throw new IllegalArgumentException("At least group id, artifact id and version need to be given separated by ':'");
            }
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = parts[2];
            String packaging = DEFAULT_PACKAGING;
            if (parts.length > 3) {
                packaging = parts[3];
            }
            String classifier = null;
            if (parts.length > 4) {
                classifier = parts[4];
            }
            return new MavenCoordinates(groupId, artifactId, version, packaging, classifier);
        }

        @NotNull
        public String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public String getArtifactId() {
            return this.artifactId;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @NotNull
        public String getPackaging() {
            return this.packaging;
        }

        @Nullable
        public String getClassifier() {
            return this.classifier;
        }

        public String toString() {
            return "MavenCoordinates [" + (this.groupId != null ? "groupId=" + this.groupId + ", " : "") + (this.artifactId != null ? "artifactId=" + this.artifactId + ", " : "") + (this.version != null ? "version=" + this.version + ", " : "") + (this.packaging != null ? "packaging=" + this.packaging + ", " : "") + (this.classifier != null ? "classifier=" + this.classifier : "") + "]";
        }

        public int hashCode() {
            return Objects.hash(this.artifactId, this.classifier, this.groupId, this.packaging, this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenCoordinates other = (MavenCoordinates)obj;
            return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.packaging, other.packaging) && Objects.equals(this.version, other.version);
        }
    }
}

