/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.FilterValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OakIndexDefinitionValidator
implements FilterValidator,
DocumentViewXmlValidator {
    static final String MESSAGE_POTENTIAL_INDEX_IN_FILTER = "Package '%s' contains filter rule overwriting a potential index definition below '%s' but the according property allowIndexDefinitions is not set to 'true'";
    static final String MESSAGE_INDEX_AT_NODE = "Package '%s' contains index definition but the according property allowIndexDefinitions is not set to 'true'";
    private final Path packageRootPathOfNotAllowedIndexDefinition;
    private final ValidationMessageSeverity defaultMessageSeverity;

    public OakIndexDefinitionValidator(Path path, ValidationMessageSeverity defaultMessageSeverity) {
        this.packageRootPathOfNotAllowedIndexDefinition = path;
        this.defaultMessageSeverity = defaultMessageSeverity;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull WorkspaceFilter filter) {
        LinkedList<ValidationMessage> violations = new LinkedList<ValidationMessage>();
        violations.addAll(this.collectIndexPaths(filter.getFilterSets()));
        return violations;
    }

    public Collection<ValidationMessage> collectIndexPaths(List<PathFilterSet> pathFilters) {
        LinkedList<ValidationMessage> violations = new LinkedList<ValidationMessage>();
        for (PathFilterSet pathFilter : pathFilters) {
            if (!pathFilter.isAncestor("/oak:index") && !pathFilter.getRoot().contains("/oak:index/") && !pathFilter.getRoot().endsWith("/oak:index")) continue;
            if (pathFilter.getRoot().contains("/rep:policy")) {
                violations.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Ignoring filter entry " + pathFilter + " as it is referring to an ACL"));
                continue;
            }
            violations.add(new ValidationMessage(this.defaultMessageSeverity, String.format(MESSAGE_POTENTIAL_INDEX_IN_FILTER, this.packageRootPathOfNotAllowedIndexDefinition, pathFilter.getRoot())));
        }
        return violations;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        ValidationMessage violation = null;
        if ("oak:QueryIndexDefinition".equals(node.primary)) {
            violation = new ValidationMessage(this.defaultMessageSeverity, String.format(MESSAGE_INDEX_AT_NODE, this.packageRootPathOfNotAllowedIndexDefinition));
        }
        return violation != null ? Collections.singleton(violation) : null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        return null;
    }
}

