/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringValue
implements CacheValue {
    private static final Logger log = LoggerFactory.getLogger(StringValue.class);
    private final String value;

    public StringValue(@NotNull String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public int getMemory() {
        return StringValue.getMemory(this.value);
    }

    public static int getMemory(@NotNull String s) {
        long size = 56L + (long)s.length() * 2L;
        if (size > Integer.MAX_VALUE) {
            log.debug("Estimated memory footprint larger than Integer.MAX_VALUE: {}.", (Object)size);
            size = Integer.MAX_VALUE;
        }
        return (int)size;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringValue) {
            StringValue other = (StringValue)obj;
            return this.value.equals(other.value);
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    public String asString() {
        return this.value;
    }

    public static StringValue fromString(String value) {
        return new StringValue(value);
    }
}

