/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.WriteConcernException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import java.util.HashSet;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoUtils {
    MongoUtils() {
    }

    static void createIndex(MongoCollection<?> collection, String field, boolean ascending, boolean unique, boolean sparse) throws MongoException {
        MongoUtils.createIndex(collection, new String[]{field}, new boolean[]{ascending}, unique, sparse);
    }

    static void createIndex(MongoCollection<?> collection, String[] fields, boolean[] ascending, boolean unique, boolean sparse) throws MongoException {
        Preconditions.checkArgument((fields.length == ascending.length ? 1 : 0) != 0);
        BasicDBObject index = new BasicDBObject();
        for (int i = 0; i < fields.length; ++i) {
            index.put((Object)fields[i], (Object)(ascending[i] ? 1 : -1));
        }
        IndexOptions options = new IndexOptions().unique(unique).sparse(sparse);
        collection.createIndex((Bson)index, options);
    }

    static void createPartialIndex(MongoCollection<?> collection, String[] fields, boolean[] ascending, String filter) throws MongoException {
        Preconditions.checkArgument((fields.length == ascending.length ? 1 : 0) != 0);
        BasicDBObject index = new BasicDBObject();
        for (int i = 0; i < fields.length; ++i) {
            index.put((Object)fields[i], (Object)(ascending[i] ? 1 : -1));
        }
        IndexOptions options = new IndexOptions().partialFilterExpression((Bson)BasicDBObject.parse((String)filter));
        collection.createIndex((Bson)index, options);
    }

    static boolean hasIndex(MongoCollection<?> collection, String ... fields) throws MongoException {
        HashSet uniqueFields = Sets.newHashSet((Object[])fields);
        for (Document info : collection.listIndexes()) {
            Document key = (Document)info.get((Object)"key");
            HashSet indexFields = Sets.newHashSet((Iterable)key.keySet());
            if (!uniqueFields.equals(indexFields)) continue;
            return true;
        }
        return false;
    }

    static DocumentStoreException.Type getDocumentStoreExceptionTypeFor(Throwable t) {
        int code;
        DocumentStoreException.Type type = DocumentStoreException.Type.GENERIC;
        if (t instanceof MongoSocketException || t instanceof MongoWriteConcernException || t instanceof MongoNotPrimaryException) {
            type = DocumentStoreException.Type.TRANSIENT;
        } else if ((t instanceof MongoCommandException || t instanceof WriteConcernException) && ((code = ((MongoException)t).getCode()) == 11600 || code == 11601 || code == 11602)) {
            type = DocumentStoreException.Type.TRANSIENT;
        }
        return type;
    }
}

