/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.WriteConcern;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class MongoConnection {
    private static final int DEFAULT_MAX_WAIT_TIME = (int)TimeUnit.MINUTES.toMillis(1L);
    private static final WriteConcern WC_UNKNOWN = new WriteConcern("unknown");
    private static final Set<ReadConcernLevel> REPLICA_RC = ImmutableSet.of((Object)ReadConcernLevel.MAJORITY, (Object)ReadConcernLevel.LINEARIZABLE);
    private final MongoClientURI mongoURI;
    private final MongoClient mongo;

    public MongoConnection(String uri) throws MongoException {
        this(uri, MongoConnection.getDefaultBuilder());
    }

    public MongoConnection(String uri, MongoClientOptions.Builder builder) throws MongoException {
        this.mongoURI = new MongoClientURI(uri, builder);
        this.mongo = new MongoClient(this.mongoURI);
    }

    public MongoConnection(String host, int port, String database) throws MongoException {
        this("mongodb://" + host + ":" + port + "/" + database);
    }

    public DB getDB() {
        return this.mongo.getDB(this.mongoURI.getDatabase());
    }

    public DB getDB(@Nonnull String name) {
        return this.mongo.getDB(name);
    }

    public void close() {
        this.mongo.close();
    }

    public static MongoClientOptions.Builder getDefaultBuilder() {
        return new MongoClientOptions.Builder().description("MongoConnection for Oak DocumentMK").maxWaitTime(DEFAULT_MAX_WAIT_TIME).threadsAllowedToBlockForConnectionMultiplier(100);
    }

    public static String toString(MongoClientOptions opts) {
        return Objects.toStringHelper((Object)opts).add("connectionsPerHost", opts.getConnectionsPerHost()).add("connectTimeout", opts.getConnectTimeout()).add("socketTimeout", opts.getSocketTimeout()).add("socketKeepAlive", opts.isSocketKeepAlive()).add("maxWaitTime", opts.getMaxWaitTime()).add("threadsAllowedToBlockForConnectionMultiplier", opts.getThreadsAllowedToBlockForConnectionMultiplier()).add("readPreference", (Object)opts.getReadPreference().getName()).add("writeConcern", (Object)opts.getWriteConcern()).toString();
    }

    public static boolean hasWriteConcern(@Nonnull String uri) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.writeConcern(WC_UNKNOWN);
        WriteConcern wc = new MongoClientURI((String)Preconditions.checkNotNull((Object)uri), builder).getOptions().getWriteConcern();
        return !WC_UNKNOWN.equals((Object)wc);
    }

    public static boolean hasReadConcern(@Nonnull String uri) {
        ReadConcern rc = new MongoClientURI((String)Preconditions.checkNotNull((Object)uri)).getOptions().getReadConcern();
        return MongoConnection.readConcernLevel(rc) != null;
    }

    public static WriteConcern getDefaultWriteConcern(@Nonnull DB db) {
        WriteConcern w = ((DB)Preconditions.checkNotNull((Object)db)).getMongo().getReplicaSetStatus() != null ? WriteConcern.MAJORITY : WriteConcern.ACKNOWLEDGED;
        return w;
    }

    public static ReadConcern getDefaultReadConcern(@Nonnull DB db) {
        ReadConcern r = ((DB)Preconditions.checkNotNull((Object)db)).getMongo().getReplicaSetStatus() != null && MongoConnection.isMajorityWriteConcern(db) ? ReadConcern.MAJORITY : ReadConcern.LOCAL;
        return r;
    }

    public static boolean isMajorityWriteConcern(@Nonnull DB db) {
        return "majority".equals(db.getWriteConcern().getWObject());
    }

    public static boolean hasSufficientWriteConcern(@Nonnull DB db) {
        int w;
        Object wObj = ((DB)Preconditions.checkNotNull((Object)db)).getWriteConcern().getWObject();
        if (wObj instanceof Number) {
            w = ((Number)wObj).intValue();
        } else if (wObj == null) {
            w = 1;
        } else if (WriteConcern.MAJORITY.getWString().equals(wObj)) {
            w = 2;
        } else {
            throw new IllegalArgumentException("Unknown write concern: " + db.getWriteConcern());
        }
        if (db.getMongo().getReplicaSetStatus() != null) {
            return w >= 2;
        }
        return w >= 1;
    }

    public static boolean hasSufficientReadConcern(@Nonnull DB db) {
        ReadConcernLevel r = MongoConnection.readConcernLevel(((DB)Preconditions.checkNotNull((Object)db)).getReadConcern());
        if (db.getMongo().getReplicaSetStatus() == null) {
            return true;
        }
        return REPLICA_RC.contains(r);
    }

    public static ReadConcernLevel readConcernLevel(ReadConcern readConcern) {
        if (readConcern.isServerDefault()) {
            return null;
        }
        return ReadConcernLevel.fromString((String)readConcern.asDocument().getString((Object)"level").getValue());
    }
}

