/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStateCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreCache;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreObserver;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public class SecondaryStoreCacheService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private BlobStore blobStore;
    @Reference(target="(role=secondary)")
    private NodeStoreProvider secondaryStoreProvider;
    @Reference
    private Executor executor;
    @Reference
    private StatisticsProvider statisticsProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile DocumentNodeStore documentNodeStore;
    private final List<Registration> oakRegs = Lists.newArrayList();
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    private Whiteboard whiteboard;
    private BundleContext bundleContext;
    private PathFilter pathFilter;
    private final MultiplexingNodeStateDiffer differ = new MultiplexingNodeStateDiffer();

    @Activate
    private void activate(BundleContext context, Configuration config) {
        this.bundleContext = context;
        this.whiteboard = new OsgiWhiteboard(context);
        String[] includedPaths = config.includedPaths();
        this.pathFilter = new PathFilter(Arrays.asList(includedPaths), Collections.emptyList());
        SecondaryStoreBuilder builder = new SecondaryStoreBuilder(this.secondaryStoreProvider.getNodeStore()).differ(this.differ).metaPropNames(DocumentNodeStore.META_PROP_NAMES).statisticsProvider(this.statisticsProvider).pathFilter(this.pathFilter);
        SecondaryStoreCache cache = builder.buildCache();
        SecondaryStoreObserver observer = builder.buildObserver(cache);
        this.registerObserver(observer, config);
        this.regs.add(this.bundleContext.registerService(DocumentNodeStateCache.class.getName(), (Object)cache, null));
    }

    @Deactivate
    private void deactivate() {
        for (Registration registration : this.oakRegs) {
            registration.unregister();
        }
        for (ServiceRegistration serviceRegistration : this.regs) {
            serviceRegistration.unregister();
        }
    }

    PathFilter getPathFilter() {
        return this.pathFilter;
    }

    protected void bindDocumentNodeStore(DocumentNodeStore documentNodeStore) {
        this.log.info("Registering DocumentNodeStore as the differ");
        this.differ.setDelegate(documentNodeStore);
    }

    protected void unbindDocumentNodeStore(DocumentNodeStore documentNodeStore) {
        this.differ.setDelegate(NodeStateDiffer.DEFAULT_DIFFER);
    }

    private void registerObserver(Observer observer, Configuration config) {
        boolean enableAsyncObserver = config.enableAsyncObserver();
        int queueSize = config.observerQueueSize();
        if (enableAsyncObserver) {
            BackgroundObserver bgObserver = new BackgroundObserver(observer, this.executor, queueSize);
            this.oakRegs.add(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, BackgroundObserverMBean.class, (Object)bgObserver.getMBean(), (String)"BackgroundObserverStats", (String)"Secondary NodeStore observer stats"));
            observer = bgObserver;
            this.log.info("Configuring the observer for secondary NodeStore as Background Observer with queue size {}", (Object)queueSize);
        }
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", 10000);
        this.regs.add(this.bundleContext.registerService(Observer.class.getName(), (Object)observer, props));
    }

    private static class MultiplexingNodeStateDiffer
    implements NodeStateDiffer {
        private volatile NodeStateDiffer delegate = NodeStateDiffer.DEFAULT_DIFFER;

        private MultiplexingNodeStateDiffer() {
        }

        @Override
        public boolean compare(@Nonnull AbstractDocumentNodeState node, @Nonnull AbstractDocumentNodeState base, @Nonnull NodeStateDiff diff) {
            return this.delegate.compare(node, base, diff);
        }

        public void setDelegate(NodeStateDiffer delegate) {
            this.delegate = delegate;
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak DocumentNodeStateCache Provider", description="Configures a DocumentNodeStateCache based on a secondary NodeStore")
    static @interface Configuration {
        @AttributeDefinition(name="Included Paths", description="List of paths which are to be included in the secondary store")
        public String[] includedPaths() default {"/"};

        @AttributeDefinition(name="Async Observation", description="Enable async observation processing")
        public boolean enableAsyncObserver() default true;

        @AttributeDefinition(name="Observer queue size", description="Observer queue size. Used if 'enableAsyncObserver' is set to true")
        public int observerQueueSize() default 10000;
    }
}

