/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.replica;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCollectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCollectionProvider.class);
    private final Map<String, DBCollection> collections = new ConcurrentHashMap<String, DBCollection>();
    private final String originalMongoUri;
    private final String dbName;

    public NodeCollectionProvider(String originalMongoUri, String dbName) {
        this.originalMongoUri = originalMongoUri;
        this.dbName = dbName;
    }

    public void retain(Set<String> hostNames) {
        this.close((Set<String>)ImmutableSet.copyOf((java.util.Collection)Sets.difference(this.collections.keySet(), hostNames)));
    }

    public void close() {
        this.close(this.collections.keySet());
    }

    private void close(Set<String> hostNames) {
        Iterator<Map.Entry<String, DBCollection>> it = this.collections.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, DBCollection> entry = it.next();
            if (!hostNames.contains(entry.getKey())) continue;
            try {
                entry.getValue().getDB().getMongo().close();
                it.remove();
            }
            catch (MongoClientException e) {
                LOG.error("Can't close Mongo client", (Throwable)e);
            }
        }
    }

    public DBCollection get(String hostname) throws UnknownHostException {
        MongoClient client;
        if (this.collections.containsKey(hostname)) {
            return this.collections.get(hostname);
        }
        if (this.originalMongoUri == null) {
            MongoClientURI uri = new MongoClientURI("mongodb://" + hostname);
            client = new MongoClient(uri);
        } else {
            client = this.prepareClientForHostname(hostname);
        }
        DB db = client.getDB(this.dbName);
        db.getMongo().slaveOk();
        DBCollection collection = db.getCollection(Collection.NODES.toString());
        this.collections.put(hostname, collection);
        return collection;
    }

    private MongoClient prepareClientForHostname(String hostname) throws UnknownHostException {
        ServerAddress address;
        if (hostname.contains(":")) {
            String[] hostSplit = hostname.split(":");
            if (hostSplit.length != 2) {
                throw new IllegalArgumentException("Not a valid hostname: " + hostname);
            }
            address = new ServerAddress(hostSplit[0], Integer.parseInt(hostSplit[1]));
        } else {
            address = new ServerAddress(hostname);
        }
        MongoClientURI originalUri = new MongoClientURI(this.originalMongoUri);
        ArrayList<MongoCredential> credentialList = new ArrayList<MongoCredential>(1);
        if (originalUri.getCredentials() != null) {
            credentialList.add(originalUri.getCredentials());
        }
        return new MongoClient(address, credentialList, originalUri.getOptions());
    }
}

