/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.client.model.DBCollectionFindOptions;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStatus {
    private static final Logger LOG = LoggerFactory.getLogger(MongoStatus.class);
    private static final ImmutableSet<String> SERVER_DETAIL_FIELD_NAMES = ImmutableSet.builder().add((Object[])new String[]{"host", "process", "connections", "repl", "storageEngine", "mem"}).build();
    private final DB db;
    private BasicDBObject serverStatus;
    private BasicDBObject buildInfo;
    private String version;
    private Boolean majorityReadConcernSupported;
    private Boolean majorityReadConcernEnabled;

    public MongoStatus(@Nonnull DB db) {
        this.db = db;
    }

    public void checkVersion() {
        if (!this.isVersion(2, 6)) {
            String msg = "MongoDB version 2.6.0 or higher required. Currently connected to a MongoDB with version: " + this.version;
            throw new RuntimeException(msg);
        }
    }

    public boolean isMajorityReadConcernSupported() {
        if (this.majorityReadConcernSupported == null) {
            BasicDBObject stat = this.getServerStatus();
            if (stat.isEmpty()) {
                LOG.debug("User doesn't have privileges to get server status; falling back to the isMajorityReadConcernEnabled()");
                return this.isMajorityReadConcernEnabled();
            }
            if (stat.containsField("storageEngine")) {
                BasicDBObject storageEngine = (BasicDBObject)stat.get("storageEngine");
                this.majorityReadConcernSupported = storageEngine.getBoolean("supportsCommittedReads");
            } else {
                this.majorityReadConcernSupported = false;
            }
        }
        return this.majorityReadConcernSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMajorityReadConcernEnabled() {
        if (this.majorityReadConcernEnabled == null) {
            DBCollection emptyCollection = this.db.getCollection("emptyCollection-" + System.currentTimeMillis());
            try (DBCursor cursor = emptyCollection.find((DBObject)new BasicDBObject(), new DBCollectionFindOptions().readConcern(ReadConcern.MAJORITY));){
                cursor.hasNext();
                this.majorityReadConcernEnabled = true;
            }
        }
        return this.majorityReadConcernEnabled;
    }

    @Nonnull
    public String getServerDetails() {
        HashMap details = Maps.newHashMap();
        for (String key : SERVER_DETAIL_FIELD_NAMES) {
            Object value = this.getServerStatus().get(key);
            if (value == null) continue;
            details.put(key, value);
        }
        return ((Object)details).toString();
    }

    @Nonnull
    public String getVersion() {
        if (this.version == null) {
            String v = this.getServerStatus().getString("version");
            if (v == null) {
                v = this.getBuildInfo().getString("version");
            }
            this.version = v;
        }
        return this.version;
    }

    boolean isVersion(int requiredMajor, int requiredMinor) {
        String v = this.getVersion();
        Matcher m = Pattern.compile("^(\\d+)\\.(\\d+)\\..*").matcher(v);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed MongoDB version: " + v);
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        if (major > requiredMajor) {
            return true;
        }
        if (major == requiredMajor) {
            return minor >= requiredMinor;
        }
        return false;
    }

    private BasicDBObject getServerStatus() {
        if (this.serverStatus == null) {
            this.serverStatus = this.db.command("serverStatus");
        }
        return this.serverStatus;
    }

    private BasicDBObject getBuildInfo() {
        if (this.buildInfo == null) {
            this.buildInfo = this.db.command("buildInfo");
        }
        return this.buildInfo;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setServerStatus(BasicDBObject serverStatus) {
        this.majorityReadConcernSupported = null;
        this.serverStatus = serverStatus;
    }
}

