/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.BackgroundWriteStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.PathComparator;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.MapFactory;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnsavedModifications {
    private static final Logger LOG = LoggerFactory.getLogger(UnsavedModifications.class);
    static final int BACKGROUND_MULTI_UPDATE_LIMIT = 100;
    private final ConcurrentMap<String, Revision> map = MapFactory.getInstance().create();

    UnsavedModifications() {
    }

    @CheckForNull
    public Revision put(@Nonnull String path, @Nonnull Revision revision) {
        block2: {
            Revision previous;
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkNotNull((Object)revision);
            while (true) {
                if ((previous = (Revision)this.map.get(path)) == null) {
                    if (this.map.putIfAbsent(path, revision) != null) continue;
                    return null;
                }
                if (previous.compareRevisionTime(revision) >= 0) break block2;
                if (this.map.replace(path, previous, revision)) break;
            }
            return previous;
        }
        return null;
    }

    @CheckForNull
    public Revision get(String path) {
        return (Revision)this.map.get(path);
    }

    @Nonnull
    public java.util.Collection<String> getPaths() {
        return this.map.keySet();
    }

    @Nonnull
    public Iterable<String> getPaths(final @Nonnull Revision start) {
        if (this.map.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)Iterables.filter(this.map.entrySet(), (Predicate)new Predicate<Map.Entry<String, Revision>>(){

            public boolean apply(Map.Entry<String, Revision> input) {
                return start.compareRevisionTime(input.getValue()) < 1;
            }
        }), (Function)new Function<Map.Entry<String, Revision>, String>(){

            public String apply(Map.Entry<String, Revision> input) {
                return input.getKey();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundWriteStats persist(@Nonnull DocumentStore store, @Nonnull Supplier<Revision> sweepRevision, @Nonnull Snapshot snapshot, @Nonnull Lock lock) {
        Revision sweepRev;
        TreeMap pending;
        BackgroundWriteStats stats = new BackgroundWriteStats();
        if (this.map.size() == 0) {
            return stats;
        }
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull(sweepRevision);
        Preconditions.checkNotNull((Object)snapshot);
        Preconditions.checkNotNull((Object)lock);
        Stopwatch sw = Stopwatch.createStarted();
        lock.lock();
        stats.lock = sw.elapsed(TimeUnit.MILLISECONDS);
        sw.reset().start();
        try {
            snapshot.acquiring(this.getMostRecentRevision());
            pending = Maps.newTreeMap(PathComparator.INSTANCE);
            pending.putAll(this.map);
            sweepRev = (Revision)sweepRevision.get();
        }
        finally {
            lock.unlock();
        }
        stats.num = pending.size();
        ArrayList updates = Lists.newArrayList();
        HashMap pathToRevision = Maps.newHashMap();
        for (Iterable batch : Iterables.partition(pending.entrySet(), (int)100)) {
            for (Map.Entry entry : batch) {
                String p = (String)entry.getKey();
                Revision r = (Revision)entry.getValue();
                if (PathUtils.denotesRoot((String)((String)entry.getKey()))) continue;
                updates.add(UnsavedModifications.newUpdateOp(p, r));
                pathToRevision.put(p, r);
            }
            if (updates.isEmpty()) continue;
            store.createOrUpdate(Collection.NODES, updates);
            ++stats.calls;
            for (Map.Entry entry : pathToRevision.entrySet()) {
                this.map.remove(entry.getKey(), entry.getValue());
                LOG.debug("Updated _lastRev to {} on {}", entry.getValue(), entry.getKey());
            }
            updates.clear();
            pathToRevision.clear();
        }
        Revision rootRev = (Revision)pending.get("/");
        if (rootRev != null) {
            UpdateOp rootUpdate = UnsavedModifications.newUpdateOp("/", rootRev);
            if (sweepRev != null) {
                NodeDocument.setSweepRevision(rootUpdate, sweepRev);
                LOG.debug("Updating _sweepRev to {}", (Object)sweepRev);
            }
            store.findAndUpdate(Collection.NODES, rootUpdate);
            ++stats.calls;
            this.map.remove("/", rootRev);
            LOG.debug("Updated _lastRev to {} on {}", (Object)rootRev, (Object)"/");
            int cid = rootRev.getClusterId();
            if (store.find(Collection.CLUSTER_NODES, String.valueOf(cid)) != null) {
                UpdateOp updateOp = new UpdateOp(String.valueOf(cid), false);
                updateOp.equals("_id", null, String.valueOf(cid));
                updateOp.set("lastWrittenRootRev", rootRev.toString());
                store.findAndUpdate(Collection.CLUSTER_NODES, updateOp);
            }
        }
        stats.write = sw.elapsed(TimeUnit.MILLISECONDS);
        return stats;
    }

    public String toString() {
        return this.map.toString();
    }

    private static UpdateOp newUpdateOp(String path, Revision r) {
        UpdateOp updateOp = Commit.createUpdateOp(path, r, false);
        NodeDocument.setLastRev(updateOp, r);
        return updateOp;
    }

    private Revision getMostRecentRevision() {
        Revision rev = (Revision)this.map.get("/");
        if (rev == null) {
            for (Revision r : this.map.values()) {
                rev = Utils.max(rev, r);
            }
        }
        return rev;
    }

    public static interface Snapshot {
        public static final Snapshot IGNORE = new Snapshot(){

            @Override
            public void acquiring(Revision mostRecent) {
            }
        };

        public void acquiring(Revision var1);
    }
}

