/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;

class MergeCommit
extends Commit {
    private final SortedSet<Revision> mergeRevs;
    private final Set<Revision> branchCommits = Sets.newHashSet();

    MergeCommit(DocumentNodeStore nodeStore, RevisionVector baseRevision, SortedSet<Revision> revisions) {
        super(nodeStore, revisions.last(), baseRevision);
        this.mergeRevs = revisions;
    }

    SortedSet<Revision> getMergeRevisions() {
        return this.mergeRevs;
    }

    void addBranchCommits(@Nonnull Branch branch) {
        for (Revision r : branch.getCommits()) {
            if (branch.getCommit(r).isRebase()) continue;
            this.branchCommits.add(r);
        }
    }

    @Override
    public void applyToCache(RevisionVector before, boolean isBranchCommit) {
        this.nodeStore.revisionsMerged(this.branchCommits);
    }
}

