/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilderBase;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobReferenceIterator;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBVersionGCSupport;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DocumentMK {
    static final Logger LOG = LoggerFactory.getLogger(DocumentMK.class);
    static final int MANY_CHILDREN_THRESHOLD = DocumentNodeStoreBuilder.MANY_CHILDREN_THRESHOLD;
    static final int UPDATE_LIMIT = DocumentNodeStoreBuilder.UPDATE_LIMIT;
    protected final DocumentNodeStore nodeStore;
    protected final DocumentStore store;

    DocumentMK(Builder builder) {
        this.nodeStore = builder.getNodeStore();
        this.store = this.nodeStore.getDocumentStore();
    }

    public void dispose() {
        this.nodeStore.dispose();
    }

    void backgroundRead() {
        this.nodeStore.runBackgroundReadOperations();
    }

    void backgroundWrite() {
        this.nodeStore.runBackgroundUpdateOperations();
    }

    void runBackgroundOperations() {
        this.nodeStore.runBackgroundOperations();
    }

    public DocumentNodeStore getNodeStore() {
        return this.nodeStore;
    }

    ClusterNodeInfo getClusterInfo() {
        return this.nodeStore.getClusterInfo();
    }

    int getPendingWriteCount() {
        return this.nodeStore.getPendingWriteCount();
    }

    public String getHeadRevision() throws DocumentStoreException {
        return this.nodeStore.getHeadRevision().toString();
    }

    public String checkpoint(long lifetime) throws DocumentStoreException {
        try {
            return this.nodeStore.checkpoint(lifetime);
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) throws DocumentStoreException {
        if (depth != 0) {
            throw new DocumentStoreException("Only depth 0 is supported, depth is " + depth);
        }
        if (path == null || path.equals("")) {
            path = "/";
        }
        RevisionVector fromRev = RevisionVector.fromString(fromRevisionId);
        RevisionVector toRev = RevisionVector.fromString(toRevisionId);
        DocumentNodeState before = this.nodeStore.getNode(path, fromRev);
        DocumentNodeState after = this.nodeStore.getNode(path, toRev);
        if (before == null || after == null) {
            String msg = String.format("Diff is only supported if the node exists in both cases. Node [%s], fromRev [%s] -> %s, toRev [%s] -> %s", path, fromRev, before != null, toRev, after != null);
            throw new DocumentStoreException(msg);
        }
        JsopDiff diff = new JsopDiff(path, depth);
        after.compareAgainstBaseState((NodeState)before, (NodeStateDiff)diff);
        return diff.toString();
    }

    public boolean nodeExists(String path, String revisionId) throws DocumentStoreException {
        DocumentNodeState n;
        if (!PathUtils.isAbsolute((String)path)) {
            throw new DocumentStoreException("Path is not absolute: " + path);
        }
        revisionId = revisionId != null ? revisionId : this.nodeStore.getHeadRevision().toString();
        RevisionVector rev = RevisionVector.fromString(revisionId);
        try {
            n = this.nodeStore.getNode(path, rev);
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
        return n != null;
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws DocumentStoreException {
        if (depth != 0) {
            throw new DocumentStoreException("Only depth 0 is supported, depth is " + depth);
        }
        revisionId = revisionId != null ? revisionId : this.nodeStore.getHeadRevision().toString();
        RevisionVector rev = RevisionVector.fromString(revisionId);
        try {
            int max;
            DocumentNodeState n = this.nodeStore.getNode(path, rev);
            if (n == null) {
                return null;
            }
            JsopStream json = new JsopStream();
            boolean includeId = filter != null && filter.contains(":id");
            boolean bl = filter != null && filter.contains(":hash");
            json.object();
            DocumentMK.append(n, (JsopWriter)json, includeId |= bl);
            if (maxChildNodes == -1) {
                max = Integer.MAX_VALUE;
                maxChildNodes = Integer.MAX_VALUE;
            } else {
                long m = (long)maxChildNodes + offset;
                max = (int)Math.min(m, Integer.MAX_VALUE);
            }
            DocumentNodeState.Children c = this.nodeStore.getChildren(n, null, max);
            for (long i = offset; i < (long)c.children.size() && maxChildNodes-- > 0; ++i) {
                String name = c.children.get((int)i);
                json.key(name).object().endObject();
            }
            if (c.hasMore) {
                json.key(":childNodeCount").value(Long.MAX_VALUE);
            } else {
                json.key(":childNodeCount").value((long)c.children.size());
            }
            json.endObject();
            return json.toString();
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
    }

    public String commit(String rootPath, String jsonDiff, String baseRevId, String message) throws DocumentStoreException {
        RevisionVector rev;
        boolean success = false;
        Commit commit = this.nodeStore.newCommit(baseRevId != null ? RevisionVector.fromString(baseRevId) : null, null);
        try {
            RevisionVector baseRev = commit.getBaseRevision();
            boolean isBranch = baseRev != null && baseRev.isBranch();
            this.parseJsonDiff(commit, jsonDiff, rootPath);
            commit.apply();
            rev = this.nodeStore.done(commit, isBranch, CommitInfo.EMPTY);
            success = true;
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
        finally {
            if (!success) {
                this.nodeStore.canceled(commit);
            }
        }
        return rev.toString();
    }

    public String branch(@Nullable String trunkRevisionId) throws DocumentStoreException {
        RevisionVector revision = trunkRevisionId != null ? RevisionVector.fromString(trunkRevisionId) : this.nodeStore.getHeadRevision();
        return revision.asBranchRevision(this.nodeStore.getClusterId()).toString();
    }

    public String merge(String branchRevisionId, String message) throws DocumentStoreException {
        RevisionVector revision = RevisionVector.fromString(branchRevisionId);
        if (!revision.isBranch()) {
            throw new DocumentStoreException("Not a branch: " + branchRevisionId);
        }
        try {
            return this.nodeStore.merge(revision, CommitInfo.EMPTY).toString();
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
        catch (CommitFailedException e) {
            throw new DocumentStoreException(e);
        }
    }

    @Nonnull
    public String rebase(@Nonnull String branchRevisionId, @Nullable String newBaseRevisionId) throws DocumentStoreException {
        RevisionVector r = RevisionVector.fromString(branchRevisionId);
        RevisionVector base = newBaseRevisionId != null ? RevisionVector.fromString(newBaseRevisionId) : this.nodeStore.getHeadRevision();
        return this.nodeStore.rebase(r, base).toString();
    }

    @Nonnull
    public String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws DocumentStoreException {
        RevisionVector branch = RevisionVector.fromString(branchRevisionId);
        if (!branch.isBranch()) {
            throw new DocumentStoreException("Not a branch revision: " + branchRevisionId);
        }
        RevisionVector ancestor = RevisionVector.fromString(ancestorRevisionId);
        if (!ancestor.isBranch()) {
            throw new DocumentStoreException("Not a branch revision: " + ancestorRevisionId);
        }
        try {
            return this.nodeStore.reset(branch, ancestor).toString();
        }
        catch (DocumentStoreException e) {
            throw new DocumentStoreException(e);
        }
    }

    public long getLength(String blobId) throws DocumentStoreException {
        try {
            return this.nodeStore.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new DocumentStoreException(e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws DocumentStoreException {
        try {
            int read = this.nodeStore.getBlobStore().readBlob(blobId, pos, buff, off, length);
            return read < 0 ? 0 : read;
        }
        catch (Exception e) {
            throw new DocumentStoreException(e);
        }
    }

    public String write(InputStream in) throws DocumentStoreException {
        try {
            return this.nodeStore.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new DocumentStoreException(e);
        }
    }

    public DocumentStore getDocumentStore() {
        return this.store;
    }

    private void parseJsonDiff(Commit commit, String json, String rootPath) {
        int r;
        RevisionVector baseRev = commit.getBaseRevision();
        String baseRevId = baseRev != null ? baseRev.toString() : null;
        HashSet added = Sets.newHashSet();
        JsopTokenizer t = new JsopTokenizer(json);
        block7: while ((r = t.read()) != 0) {
            String path = PathUtils.concat((String)rootPath, (String)t.readString());
            switch (r) {
                case 43: {
                    t.read(58);
                    t.read(123);
                    this.parseAddNode(commit, (JsopReader)t, path);
                    added.add(path);
                    continue block7;
                }
                case 45: {
                    DocumentNodeState toRemove = this.nodeStore.getNode(path, commit.getBaseRevision());
                    if (toRemove == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    commit.removeNode(path, (NodeState)toRemove);
                    this.markAsDeleted(toRemove, commit, true);
                    continue block7;
                }
                case 94: {
                    t.read(58);
                    String value = t.matches(5) ? null : t.readRawValue().trim();
                    String p = PathUtils.getParentPath((String)path);
                    if (!added.contains(p) && this.nodeStore.getNode(p, commit.getBaseRevision()) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    String propertyName = PathUtils.getName((String)path);
                    commit.updateProperty(p, propertyName, value);
                    continue block7;
                }
                case 62: {
                    DocumentNodeState source;
                    t.read(58);
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute((String)targetPath)) {
                        targetPath = PathUtils.concat((String)rootPath, (String)targetPath);
                    }
                    if ((source = this.nodeStore.getNode(path, baseRev)) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new DocumentStoreException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    this.moveNode(source, targetPath, commit);
                    continue block7;
                }
                case 42: {
                    DocumentNodeState source;
                    t.read(58);
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute((String)targetPath)) {
                        targetPath = PathUtils.concat((String)rootPath, (String)targetPath);
                    }
                    if ((source = this.nodeStore.getNode(path, baseRev)) == null) {
                        throw new DocumentStoreException("Node not found: " + path + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new DocumentStoreException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    this.copyNode(source, targetPath, commit);
                    continue block7;
                }
            }
            throw new DocumentStoreException("token: " + (char)t.getTokenType());
        }
    }

    private void parseAddNode(Commit commit, JsopReader t, String path) {
        ArrayList props = Lists.newArrayList();
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    String childPath = PathUtils.concat((String)path, (String)key);
                    this.parseAddNode(commit, t, childPath);
                    continue;
                }
                String value = t.readRawValue().trim();
                props.add(this.nodeStore.createPropertyState(key, value));
            } while (t.matches(44));
            t.read(125);
        }
        DocumentNodeState n = new DocumentNodeState(this.nodeStore, path, new RevisionVector(commit.getRevision()), props, false, null);
        commit.addNode(n);
    }

    private void copyNode(DocumentNodeState source, String targetPath, Commit commit) {
        this.moveOrCopyNode(false, source, targetPath, commit);
    }

    private void moveNode(DocumentNodeState source, String targetPath, Commit commit) {
        this.moveOrCopyNode(true, source, targetPath, commit);
    }

    private void markAsDeleted(DocumentNodeState node, Commit commit, boolean subTreeAlso) {
        commit.removeNode(node.getPath(), (NodeState)node);
        if (subTreeAlso) {
            for (DocumentNodeState child : this.nodeStore.getChildNodes(node, null, Integer.MAX_VALUE)) {
                this.markAsDeleted(child, commit, true);
            }
        }
    }

    private void moveOrCopyNode(boolean move, DocumentNodeState source, String targetPath, Commit commit) {
        RevisionVector destRevision = commit.getBaseRevision().update(commit.getRevision());
        DocumentNodeState newNode = new DocumentNodeState(this.nodeStore, targetPath, destRevision, source.getProperties(), false, null);
        commit.addNode(newNode);
        if (move) {
            this.markAsDeleted(source, commit, false);
        }
        for (DocumentNodeState child : this.nodeStore.getChildNodes(source, null, Integer.MAX_VALUE)) {
            String childName = PathUtils.getName((String)child.getPath());
            String destChildPath = PathUtils.concat((String)targetPath, (String)childName);
            this.moveOrCopyNode(move, child, destChildPath, commit);
        }
    }

    private static void append(DocumentNodeState node, JsopWriter json, boolean includeId) {
        if (includeId) {
            json.key(":id").value(node.getId());
        }
        for (String name : node.getPropertyNames()) {
            json.key(name).encodedValue(node.getPropertyAsString(name));
        }
    }

    @Deprecated
    public static class Builder
    extends MongoDocumentNodeStoreBuilderBase<Builder> {
        public static final long DEFAULT_MEMORY_CACHE_SIZE = 0x10000000L;
        public static final int DEFAULT_NODE_CACHE_PERCENTAGE = 35;
        public static final int DEFAULT_PREV_DOC_CACHE_PERCENTAGE = 4;
        public static final int DEFAULT_CHILDREN_CACHE_PERCENTAGE = 15;
        public static final int DEFAULT_DIFF_CACHE_PERCENTAGE = 30;
        public static final int DEFAULT_CACHE_SEGMENT_COUNT = 16;
        public static final int DEFAULT_CACHE_STACK_MOVE_DISTANCE = 16;
        public static final int DEFAULT_UPDATE_LIMIT = 100000;
        private DocumentNodeStore nodeStore;

        public Builder setRDBConnection(DataSource ds) {
            this.setRDBConnection(ds, new RDBOptions());
            return this;
        }

        public Builder setRDBConnection(DataSource ds, RDBOptions options) {
            this.documentStoreSupplier = Suppliers.ofInstance((Object)new RDBDocumentStore(ds, this, options));
            if (this.blobStore == null) {
                RDBBlobStore s = new RDBBlobStore(ds, options);
                this.setGCBlobStore((GarbageCollectableBlobStore)s);
            }
            return this;
        }

        public Builder setRDBConnection(DataSource documentStoreDataSource, DataSource blobStoreDataSource) {
            this.documentStoreSupplier = Suppliers.ofInstance((Object)new RDBDocumentStore(documentStoreDataSource, this));
            if (this.blobStore == null) {
                RDBBlobStore s = new RDBBlobStore(blobStoreDataSource);
                this.setGCBlobStore((GarbageCollectableBlobStore)s);
            }
            return this;
        }

        public DocumentNodeStore getNodeStore() {
            if (this.nodeStore == null) {
                this.nodeStore = this.build();
            }
            return this.nodeStore;
        }

        @Override
        public VersionGCSupport createVersionGCSupport() {
            DocumentStore store = this.getDocumentStore();
            if (store instanceof RDBDocumentStore) {
                return new RDBVersionGCSupport((RDBDocumentStore)store);
            }
            return super.createVersionGCSupport();
        }

        @Override
        public Iterable<ReferencedBlob> createReferencedBlobs(DocumentNodeStore ns) {
            DocumentStore store = this.getDocumentStore();
            if (store instanceof RDBDocumentStore) {
                return () -> new RDBBlobReferenceIterator(ns, (RDBDocumentStore)store);
            }
            return super.createReferencedBlobs(ns);
        }

        public DocumentMK open() {
            return new DocumentMK(this);
        }
    }
}

