/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Collision {
    private static final Logger LOG = LoggerFactory.getLogger(Collision.class);
    private final NodeDocument document;
    private final Revision theirRev;
    private final UpdateOp ourOp;
    private final Revision ourRev;
    private final RevisionContext context;

    Collision(@Nonnull NodeDocument document, @Nonnull Revision theirRev, @Nonnull UpdateOp ourOp, @Nonnull Revision ourRev, @Nonnull RevisionContext context) {
        this.document = (NodeDocument)Preconditions.checkNotNull((Object)document);
        this.theirRev = (Revision)Preconditions.checkNotNull((Object)theirRev);
        this.ourOp = (UpdateOp)Preconditions.checkNotNull((Object)ourOp);
        this.ourRev = (Revision)Preconditions.checkNotNull((Object)ourRev);
        this.context = (RevisionContext)Preconditions.checkNotNull((Object)context);
    }

    @Nonnull
    Revision mark(DocumentStore store) throws DocumentStoreException {
        if (Collision.markCommitRoot(this.document, this.theirRev, this.ourRev, store, this.context)) {
            return this.theirRev;
        }
        NodeDocument newDoc = Collection.NODES.newDocument(store);
        this.document.deepCopy(newDoc);
        UpdateUtils.applyChanges(newDoc, this.ourOp);
        if (!Collision.markCommitRoot(newDoc, this.ourRev, this.theirRev, store, this.context)) {
            throw new IllegalStateException("Unable to annotate our revision with collision marker. Our revision: " + this.ourRev + ", their revision: " + this.theirRev + ", document:\n" + newDoc.format());
        }
        return this.ourRev;
    }

    boolean isConflicting() throws DocumentStoreException {
        if (this.document.getDeleted().containsKey(this.theirRev)) {
            return true;
        }
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> entry : this.ourOp.getChanges().entrySet()) {
            String name = entry.getKey().getName();
            if (NodeDocument.isDeletedEntry(name)) {
                return true;
            }
            if (!Utils.isPropertyName(name) || !this.document.getValueMap(name).containsKey(this.theirRev)) continue;
            return true;
        }
        return false;
    }

    private static boolean markCommitRoot(@Nonnull NodeDocument document, @Nonnull Revision revision, @Nonnull Revision other, @Nonnull DocumentStore store, @Nonnull RevisionContext context) {
        String commitRootPath;
        String p = document.getPath();
        if (document.containsRevision(revision)) {
            if (Utils.isCommitted(context.getCommitValue(revision, document))) {
                return false;
            }
            commitRootPath = p;
        } else {
            commitRootPath = document.getCommitRootPath(revision);
            if (commitRootPath == null) {
                Collision.throwNoCommitRootException(revision, document);
            }
        }
        UpdateOp op = new UpdateOp(Utils.getIdFromPath(commitRootPath), false);
        NodeDocument commitRoot = store.find(Collection.NODES, op.getId());
        if (Utils.isCommitted(context.getCommitValue(revision, commitRoot))) {
            return false;
        }
        if (commitRoot.getLocalMap("_collisions").containsKey(revision)) {
            return true;
        }
        NodeDocument.addCollision(op, revision, other);
        String commitValue = (String)commitRoot.getLocalRevisions().get(revision);
        if (commitValue == null) {
            op.containsMapEntry("_revisions", revision, false);
        } else {
            op.equals("_revisions", revision, commitValue);
        }
        commitRoot = store.findAndUpdate(Collection.NODES, op);
        if (commitRoot == null) {
            return false;
        }
        if (Utils.isCommitted(context.getCommitValue(revision, commitRoot))) {
            UpdateOp revert = new UpdateOp(op.getId(), false);
            NodeDocument.removeCollision(revert, revision);
            store.findAndUpdate(Collection.NODES, op);
            return false;
        }
        LOG.debug("Marked collision on: {} for {} ({})", new Object[]{commitRootPath, p, revision});
        return true;
    }

    private static void throwNoCommitRootException(@Nonnull Revision revision, @Nonnull Document document) throws DocumentStoreException {
        throw new DocumentStoreException("No commit root for revision: " + revision + ", document: " + document.format());
    }
}

