/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.split.UnclosedSegmentArchiveReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SplitSegmentArchiveManager
implements SegmentArchiveManager {
    private final SegmentArchiveManager roArchiveManager;
    private final SegmentArchiveManager rwArchiveManager;
    private final List<String> roArchiveList;

    public SplitSegmentArchiveManager(SegmentArchiveManager roArchiveManager, SegmentArchiveManager rwArchiveManager, String lastRoArchive) throws IOException {
        this.roArchiveManager = roArchiveManager;
        this.rwArchiveManager = rwArchiveManager;
        this.roArchiveList = this.getRoArchives(lastRoArchive);
    }

    private List<String> getRoArchives(String lastRoArchive) throws IOException {
        List<String> archives = this.roArchiveManager.listArchives();
        Collections.sort(archives);
        int index = archives.indexOf(lastRoArchive);
        if (index == -1) {
            throw new IllegalStateException("Can't find archive " + lastRoArchive + " in the read-only persistence");
        }
        return new ArrayList<String>(archives.subList(0, index + 1));
    }

    @Override
    @NotNull
    public List<String> listArchives() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.roArchiveList);
        result.addAll(this.rwArchiveManager.listArchives());
        return result;
    }

    @Override
    @Nullable
    public SegmentArchiveReader open(@NotNull String archiveName) throws IOException {
        if (this.isReadOnly(archiveName)) {
            SegmentArchiveReader reader = null;
            try {
                reader = this.roArchiveManager.open(archiveName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (reader == null) {
                reader = this.roArchiveManager.forceOpen(archiveName);
            }
            return Optional.ofNullable(reader).map(UnclosedSegmentArchiveReader::new).orElse(null);
        }
        return this.rwArchiveManager.open(archiveName);
    }

    @Override
    @Nullable
    public SegmentArchiveReader forceOpen(String archiveName) throws IOException {
        if (this.isReadOnly(archiveName)) {
            return this.roArchiveManager.forceOpen(archiveName);
        }
        return this.rwArchiveManager.forceOpen(archiveName);
    }

    @Override
    @NotNull
    public SegmentArchiveWriter create(@NotNull String archiveName) throws IOException {
        return this.rwArchiveManager.create(archiveName);
    }

    @Override
    public boolean delete(@NotNull String archiveName) {
        if (this.isReadOnly(archiveName)) {
            return false;
        }
        return this.rwArchiveManager.delete(archiveName);
    }

    @Override
    public boolean renameTo(@NotNull String from, @NotNull String to) {
        if (this.isReadOnly(from) || this.isReadOnly(to)) {
            return false;
        }
        return this.rwArchiveManager.renameTo(from, to);
    }

    @Override
    public void copyFile(@NotNull String from, @NotNull String to) throws IOException {
        if (this.isReadOnly(to)) {
            throw new IOException("Can't overwrite the read-only " + to);
        }
        if (this.isReadOnly(from)) {
            throw new IOException("Can't copy the archive between persistence " + from + " -> " + to);
        }
        this.rwArchiveManager.copyFile(from, to);
    }

    @Override
    public boolean exists(@NotNull String archiveName) {
        return this.isReadOnly(archiveName) || this.rwArchiveManager.exists(archiveName);
    }

    @Override
    public void recoverEntries(@NotNull String archiveName, @NotNull LinkedHashMap<UUID, byte[]> entries) throws IOException {
        if (this.isReadOnly(archiveName)) {
            this.roArchiveManager.recoverEntries(archiveName, entries);
        } else {
            this.rwArchiveManager.recoverEntries(archiveName, entries);
        }
    }

    @Override
    public void backup(@NotNull String archiveName, @NotNull String backupArchiveName, @NotNull Set<UUID> recoveredEntries) throws IOException {
        if (!this.isReadOnly(archiveName)) {
            this.rwArchiveManager.backup(archiveName, backupArchiveName, recoveredEntries);
        }
    }

    @Override
    public boolean isReadOnly(String archiveName) {
        return this.roArchiveList.contains(archiveName);
    }
}

