/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.oak.api.IllegalRepositoryStateException;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.internal.concurrent.ForkJoinUtils;
import org.apache.jackrabbit.oak.segment.file.FileReaper;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarPersistence;
import org.apache.jackrabbit.oak.segment.file.tar.TarReader;
import org.apache.jackrabbit.oak.segment.file.tar.TarRecovery;
import org.apache.jackrabbit.oak.segment.file.tar.TarWriter;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.NoopStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarFiles
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarFiles.class);
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(data)((0|[1-9][0-9]*)[0-9]{4})([a-z])?.tar");
    private final long maxFileSize;
    private SegmentArchiveManager archiveManager;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Node readers;
    private TarWriter writer;
    private volatile boolean shutdown;
    private final CounterStats readerCount;
    private final CounterStats segmentCount;
    private final boolean readOnly;
    private final TarRecovery tarRecovery;
    private boolean initialised;

    private static Node reverse(Node n) {
        Node r = null;
        while (n != null) {
            r = new Node(n.reader, r);
            n = n.next;
        }
        return r;
    }

    private static Iterable<TarReader> iterable(final Node head) {
        return new Iterable<TarReader>(){

            @Override
            @NotNull
            public Iterator<TarReader> iterator() {
                return new Iterator<TarReader>(){
                    private Node next;
                    {
                        this.next = head;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public TarReader next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Node current = this.next;
                        this.next = current.next;
                        return current.reader;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("not implemented");
                    }
                };
            }
        };
    }

    private static Map<Integer, Map<Character, String>> collectFiles(SegmentArchiveManager archiveManager) throws IOException {
        HashMap<Integer, Map<Character, String>> dataFiles = new HashMap<Integer, Map<Character, String>>();
        for (String file : archiveManager.listArchives()) {
            Matcher matcher = FILE_NAME_PATTERN.matcher(file);
            if (!matcher.matches()) continue;
            Integer index = Integer.parseInt(matcher.group(2));
            HashMap<Character, String> files = (HashMap<Character, String>)dataFiles.get(index);
            if (files == null) {
                files = new HashMap<Character, String>();
                dataFiles.put(index, files);
            }
            Character generation = Character.valueOf('a');
            if (matcher.group(4) != null) {
                generation = Character.valueOf(matcher.group(4).charAt(0));
            }
            Validate.checkState((files.put(generation, file) == null ? 1 : 0) != 0);
        }
        return dataFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static int getSegmentCount(TarReader reader) {
        return reader.getEntries().length;
    }

    private TarFiles(Builder builder) throws IOException {
        this.maxFileSize = builder.maxFileSize;
        this.archiveManager = builder.buildArchiveManager();
        this.readerCount = builder.readerCountStats;
        this.segmentCount = builder.segmentCountStats;
        this.readOnly = builder.readOnly;
        this.tarRecovery = builder.tarRecovery;
        if (builder.initialiseReadersAndWriters) {
            this.init();
        }
    }

    public void init() throws IOException {
        Map<Integer, Map<Character, String>> map = TarFiles.collectFiles(this.archiveManager);
        Object[] indices = map.keySet().toArray(new Integer[map.size()]);
        Arrays.sort(indices);
        if (indices.length > 0) {
            try {
                ((List)ForkJoinUtils.invokeInCustomPool((String)"segmentstore-init", (int)Math.min(indices.length, 32), () -> this.lambda$init$1((Integer[])indices, map))).forEach(reader -> {
                    this.segmentCount.inc((long)TarFiles.getSegmentCount(reader));
                    this.readers = new Node((TarReader)reader, this.readers);
                    this.readerCount.inc();
                });
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }
        if (!this.readOnly) {
            int writeNumber = 0;
            if (indices.length > 0) {
                writeNumber = (Integer)indices[indices.length - 1] + 1;
            }
            this.writer = new TarWriter(this.archiveManager, writeNumber, this.segmentCount);
        }
        this.initialised = true;
    }

    private void checkInitialised() {
        if (!this.initialised) {
            throw new IllegalRepositoryStateException("TarFiles not initialised");
        }
    }

    @Override
    public void close() throws IOException {
        Node head;
        TarWriter w;
        this.shutdown = true;
        this.lock.writeLock().lock();
        try {
            w = this.writer;
            head = this.readers;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        IOException exception = null;
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            try {
                reader.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String toString() {
        Node head;
        String w = null;
        this.lock.readLock().lock();
        try {
            if (this.writer != null) {
                w = this.writer.toString();
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return String.format("TarFiles{readers=%s,writer=%s}", ListUtils.toList(TarFiles.iterable(head)), w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Node head;
        long size = 0L;
        this.lock.readLock().lock();
        try {
            if (this.writer != null) {
                size = this.writer.fileLength();
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            size += reader.size();
        }
        return size;
    }

    private static int getSize(Node head) {
        return IterableUtils.size(TarFiles.iterable(head));
    }

    public int readerCount() {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return TarFiles.getSize(head);
    }

    public int segmentCount() {
        Node head;
        int count = 0;
        this.lock.readLock().lock();
        try {
            if (this.writer != null) {
                count = this.writer.getEntryCount();
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            count += TarFiles.getSegmentCount(reader);
        }
        return count;
    }

    public void flush() throws IOException {
        this.checkInitialised();
        this.lock.readLock().lock();
        try {
            this.writer.flush();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSegment(long msb, long lsb) {
        Node head;
        this.lock.readLock().lock();
        try {
            if (this.writer != null && this.writer.containsEntry(msb, lsb)) {
                boolean bl = true;
                return bl;
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            if (!reader.containsEntry(msb, lsb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Buffer readSegment(long msb, long lsb) {
        try {
            TarReader reader;
            Buffer b;
            Node head;
            this.lock.readLock().lock();
            try {
                Buffer b2;
                if (this.writer != null && (b2 = this.writer.readEntry(msb, lsb)) != null) {
                    Buffer buffer = b2;
                    return buffer;
                }
                head = this.readers;
            }
            finally {
                this.lock.readLock().unlock();
            }
            Iterator<TarReader> iterator = TarFiles.iterable(head).iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((b = (reader = iterator.next()).readEntry(msb, lsb)) == null);
            return b;
        }
        catch (IOException e) {
            log.warn("Unable to read from TAR file", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSegment(UUID id, byte[] buffer, int offset, int length, GCGeneration generation, Set<UUID> references, Set<String> binaryReferences) throws IOException {
        this.checkInitialised();
        this.lock.writeLock().lock();
        try {
            long size = this.writer.writeEntry(id.getMostSignificantBits(), id.getLeastSignificantBits(), buffer, offset, length, generation);
            if (references != null) {
                for (UUID uUID : references) {
                    this.writer.addGraphEdge(id, uUID);
                }
            }
            if (binaryReferences != null) {
                for (String string : binaryReferences) {
                    this.writer.addBinaryReference(generation, id, string);
                }
            }
            int entryCount = this.writer.getEntryCount();
            if (size >= this.maxFileSize || entryCount >= this.writer.getMaxEntryCount()) {
                this.internalNewWriter();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void internalNewWriter() throws IOException {
        TarWriter newWriter = this.writer.createNextGeneration();
        if (newWriter == this.writer) {
            return;
        }
        TarReader reader = TarReader.open(this.writer.getFileName(), this.archiveManager);
        this.readers = new Node(reader, this.readers);
        this.segmentCount.inc((long)TarFiles.getSegmentCount(reader));
        this.readerCount.inc();
        this.writer = newWriter;
    }

    void newWriter() throws IOException {
        this.checkInitialised();
        this.lock.writeLock().lock();
        try {
            this.internalNewWriter();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public CleanupResult cleanup(CleanupContext context) throws IOException {
        void var7_14;
        Node swept;
        long reclaimed;
        HashSet<UUID> references;
        Node head;
        this.checkInitialised();
        CleanupResult result = new CleanupResult();
        result.removableFiles = new ArrayList<String>();
        result.reclaimedSegmentIds = new HashSet<UUID>();
        this.lock.writeLock().lock();
        this.lock.readLock().lock();
        try {
            try {
                this.internalNewWriter();
            }
            finally {
                this.lock.writeLock().unlock();
            }
            head = this.readers;
            references = new HashSet<UUID>(context.initialReferences());
        }
        finally {
            this.lock.readLock().unlock();
        }
        LinkedHashMap<TarReader, TarReader> cleaned = new LinkedHashMap<TarReader, TarReader>();
        for (TarReader tarReader : TarFiles.iterable(head)) {
            cleaned.put(tarReader, tarReader);
            result.reclaimedSize += tarReader.size();
        }
        HashSet<UUID> reclaim = new HashSet<UUID>();
        for (TarReader reader : cleaned.keySet()) {
            if (this.shutdown) {
                result.interrupted = true;
                return result;
            }
            reader.mark(references, reclaim, context);
        }
        for (TarReader reader : cleaned.keySet()) {
            if (this.shutdown) {
                result.interrupted = true;
                return result;
            }
            cleaned.put(reader, reader.sweep(reclaim, result.reclaimedSegmentIds));
        }
        while (true) {
            Object var7_13 = null;
            reclaimed = 0L;
            swept = null;
            for (TarReader reader : TarFiles.iterable(head)) {
                if (cleaned.containsKey(reader)) {
                    TarReader cleanedReader = (TarReader)cleaned.get(reader);
                    if (cleanedReader != null) {
                        swept = new Node(cleanedReader, swept);
                        reclaimed += cleanedReader.size();
                    }
                    if (cleanedReader == reader) continue;
                    Node node = new Node(reader, (Node)var7_14);
                    continue;
                }
                swept = new Node(reader, swept);
            }
            swept = TarFiles.reverse(swept);
            this.lock.writeLock().lock();
            try {
                if (this.readers == head) {
                    this.readers = swept;
                    break;
                }
                head = this.readers;
                continue;
            }
            finally {
                this.lock.writeLock().unlock();
                continue;
            }
            break;
        }
        this.readerCount.dec((long)(TarFiles.getSize(head) - TarFiles.getSize(swept)));
        this.segmentCount.dec((long)(TarFiles.getSegmentCount(head) - TarFiles.getSegmentCount(swept)));
        result.reclaimedSize -= reclaimed;
        for (TarReader closeable : TarFiles.iterable((Node)var7_14)) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.warn("Unable to close swept TAR reader", (Throwable)e);
            }
            result.removableFiles.add(closeable.getFileName());
        }
        return result;
    }

    private static int getSegmentCount(Node head) {
        int c = 0;
        for (TarReader reader : TarFiles.iterable(head)) {
            c += TarFiles.getSegmentCount(reader);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectBlobReferences(Consumer<String> collector, Predicate<GCGeneration> reclaim) throws IOException {
        Node head;
        this.checkInitialised();
        this.lock.writeLock().lock();
        try {
            if (this.writer != null) {
                this.internalNewWriter();
            }
            head = this.readers;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            reader.collectBlobReferences(collector, reclaim);
        }
    }

    public Iterable<UUID> getSegmentIds() {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (TarReader reader : TarFiles.iterable(head)) {
            ids.addAll(reader.getUUIDs());
        }
        return ids;
    }

    public Map<UUID, Set<UUID>> getGraph(String fileName) throws IOException {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            if (!fileName.equals(reader.getFileName())) continue;
            HashMap<UUID, Set<UUID>> result = new HashMap<UUID, Set<UUID>>();
            reader.getUUIDs().forEach(uuid -> result.put((UUID)uuid, Collections.emptySet()));
            result.putAll(reader.getGraph().getEdges());
            return result;
        }
        return Collections.emptyMap();
    }

    public Map<String, Set<UUID>> getIndices() {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        HashMap<String, Set<UUID>> index = new HashMap<String, Set<UUID>>();
        for (TarReader reader : TarFiles.iterable(head)) {
            index.put(reader.getFileName(), reader.getUUIDs());
        }
        return index;
    }

    public FileReaper createFileReaper() {
        this.checkInitialised();
        return new FileReaper(this.archiveManager);
    }

    private /* synthetic */ List lambda$init$1(Integer[] indices, Map map) throws Exception {
        return ((Stream)Stream.of(indices).parallel()).map(index -> {
            try {
                if (this.readOnly) {
                    return TarReader.openRO((Map)map.get(index), this.tarRecovery, this.archiveManager);
                }
                return TarReader.open((Map)map.get(index), this.tarRecovery, this.archiveManager);
            }
            catch (IOException e) {
                log.warn("Unable to open TAR file: {}", map.get(index), (Object)e);
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toUnmodifiableList());
    }

    public static class Builder {
        private File directory;
        private boolean memoryMapping;
        private boolean offHeapAccess;
        private TarRecovery tarRecovery;
        private IOMonitor ioMonitor;
        private FileStoreMonitor fileStoreMonitor;
        private RemoteStoreMonitor remoteStoreMonitor;
        private long maxFileSize;
        private boolean readOnly;
        private SegmentNodeStorePersistence persistence;
        private CounterStats readerCountStats = NoopStats.INSTANCE;
        private CounterStats segmentCountStats = NoopStats.INSTANCE;
        private boolean initialiseReadersAndWriters = true;

        private Builder() {
        }

        public Builder withDirectory(File directory) {
            this.directory = Objects.requireNonNull(directory);
            return this;
        }

        public Builder withMemoryMapping(boolean memoryMapping) {
            this.memoryMapping = memoryMapping;
            return this;
        }

        public Builder withOffHeapAccess(boolean offHeapAccess) {
            this.offHeapAccess = offHeapAccess;
            return this;
        }

        public Builder withTarRecovery(TarRecovery tarRecovery) {
            this.tarRecovery = Objects.requireNonNull(tarRecovery);
            return this;
        }

        public Builder withIOMonitor(IOMonitor ioMonitor) {
            this.ioMonitor = Objects.requireNonNull(ioMonitor);
            return this;
        }

        public Builder withFileStoreMonitor(FileStoreMonitor fileStoreStats) {
            this.fileStoreMonitor = Objects.requireNonNull(fileStoreStats);
            return this;
        }

        public Builder withRemoteStoreMonitor(RemoteStoreMonitor remoteStoreMonitor) {
            this.remoteStoreMonitor = Objects.requireNonNull(remoteStoreMonitor);
            return this;
        }

        public Builder withMaxFileSize(long maxFileSize) {
            Validate.checkArgument((maxFileSize > 0L ? 1 : 0) != 0);
            this.maxFileSize = maxFileSize;
            return this;
        }

        public Builder withReadOnly() {
            this.readOnly = true;
            return this;
        }

        public Builder withPersistence(SegmentNodeStorePersistence persistence) {
            this.persistence = persistence;
            return this;
        }

        public Builder withReaderCountStats(CounterStats readerCountStats) {
            this.readerCountStats = readerCountStats;
            return this;
        }

        public Builder withSegmentCountStats(CounterStats segmentCountStats) {
            this.segmentCountStats = segmentCountStats;
            return this;
        }

        public Builder withInitialisedReadersAndWriters(boolean initialiseReadersAndWriters) {
            this.initialiseReadersAndWriters = initialiseReadersAndWriters;
            return this;
        }

        public TarFiles build() throws IOException {
            Validate.checkState((this.directory != null ? 1 : 0) != 0, (Object)"Directory not specified");
            Validate.checkState((this.tarRecovery != null ? 1 : 0) != 0, (Object)"TAR recovery strategy not specified");
            Validate.checkState((this.ioMonitor != null ? 1 : 0) != 0, (Object)"I/O monitor not specified");
            Validate.checkState((this.readOnly || this.fileStoreMonitor != null ? 1 : 0) != 0, (Object)"File store statistics not specified");
            Validate.checkState((this.remoteStoreMonitor != null ? 1 : 0) != 0, (Object)"Remote store statistics not specified");
            Validate.checkState((this.readOnly || this.maxFileSize != 0L ? 1 : 0) != 0, (Object)"Max file size not specified");
            if (this.persistence == null) {
                this.persistence = new TarPersistence(this.directory);
            }
            return new TarFiles(this);
        }

        public File getDirectory() {
            return this.directory;
        }

        public boolean isMemoryMapping() {
            return this.memoryMapping;
        }

        public TarRecovery getTarRecovery() {
            return this.tarRecovery;
        }

        public IOMonitor getIoMonitor() {
            return this.ioMonitor;
        }

        public FileStoreMonitor getFileStoreMonitor() {
            return this.fileStoreMonitor;
        }

        public RemoteStoreMonitor getRemoteStoreMonitor() {
            return this.remoteStoreMonitor;
        }

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        private SegmentArchiveManager buildArchiveManager() throws IOException {
            return this.persistence.createArchiveManager(this.memoryMapping, this.offHeapAccess, this.ioMonitor, this.readOnly && this.fileStoreMonitor == null ? new FileStoreMonitorAdapter() : this.fileStoreMonitor, this.remoteStoreMonitor);
        }
    }

    public static class CleanupResult {
        private boolean interrupted;
        private long reclaimedSize;
        private List<String> removableFiles;
        private Set<UUID> reclaimedSegmentIds;

        private CleanupResult() {
        }

        public long getReclaimedSize() {
            return this.reclaimedSize;
        }

        public List<String> getRemovableFiles() {
            return this.removableFiles;
        }

        public Set<UUID> getReclaimedSegmentIds() {
            return this.reclaimedSegmentIds;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }
    }

    private static class Node {
        final TarReader reader;
        final Node next;

        Node(TarReader reader, Node next) {
            this.reader = reader;
            this.next = next;
        }
    }
}

