/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.segment.file.SafeRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements Closeable {
    private static int schedulerNumber = 0;
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    @NotNull
    private final AtomicLong executionCounter = new AtomicLong();
    @NotNull
    private final String name;
    @NotNull
    private final ScheduledExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler(@Nullable String name) {
        if (name == null) {
            Class<Scheduler> clazz = Scheduler.class;
            synchronized (Scheduler.class) {
                this.name = "scheduler-" + schedulerNumber;
                ++schedulerNumber;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            this.name = name;
        }
        {
            this.executor = Executors.newScheduledThreadPool(1, new SchedulerThreadFactory(this.name));
            return;
        }
    }

    public void execute(@NotNull String name, @NotNull Runnable task) {
        this.executor.execute(new SafeRunnable(name, task));
    }

    public void scheduleOnce(@NotNull String name, long delay, @NotNull TimeUnit unit, @NotNull Runnable task) {
        this.executor.schedule(new SafeRunnable(name, task), delay, unit);
    }

    public void scheduleAtFixedRate(@NotNull String name, long period, @NotNull TimeUnit unit, @NotNull Runnable task) {
        this.executor.scheduleAtFixedRate(new SafeRunnable(name, task), period, period, unit);
    }

    public void scheduleWithFixedDelay(@NotNull String name, long delay, @NotNull TimeUnit unit, @NotNull Runnable task) {
        this.executor.scheduleWithFixedDelay(new SafeRunnable(name, task), delay, delay, unit);
    }

    @Override
    public void close() {
        try {
            this.executor.shutdown();
            if (this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOG.debug("The scheduler {} was successfully shut down", (Object)this.name);
            } else {
                LOG.warn("The scheduler {} takes too long to shut down", (Object)this.name);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupt while shutting down he scheduler {}", (Object)this.name, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private static class SchedulerThreadFactory
    implements ThreadFactory {
        private final ThreadFactory threadFactory = Executors.defaultThreadFactory();
        @NotNull
        private final String name;

        public SchedulerThreadFactory(@NotNull String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread = this.threadFactory.newThread(runnable);
            thread.setName(this.name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

