/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Iterator;
import org.apache.jackrabbit.oak.commons.collections.AbstractIterator;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.data.SegmentData;
import org.jetbrains.annotations.NotNull;

public interface SegmentReferences
extends Iterable<SegmentId> {
    @NotNull
    public static SegmentReferences fromSegmentData(final @NotNull SegmentData data, final @NotNull SegmentIdProvider idProvider) {
        final int referencedSegmentIdCount = data.getSegmentReferencesCount();
        Validate.checkState((referencedSegmentIdCount + 1 < 65535 ? 1 : 0) != 0, (Object)"Segment cannot have more than 0xffff references");
        final SegmentId[] refIds = new SegmentId[referencedSegmentIdCount];
        return new SegmentReferences(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public SegmentId getSegmentId(int reference) {
                Validate.checkArgument((reference <= referencedSegmentIdCount ? 1 : 0) != 0, (String)"Segment reference out of bounds");
                SegmentId id = refIds[reference - 1];
                if (id != null) return id;
                SegmentId[] segmentIdArray = refIds;
                synchronized (refIds) {
                    id = refIds[reference - 1];
                    if (id != null) return id;
                    long msb = data.getSegmentReferenceMsb(reference - 1);
                    long lsb = data.getSegmentReferenceLsb(reference - 1);
                    refIds[reference - 1] = id = idProvider.newSegmentId(msb, lsb);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return id;
                }
            }

            @Override
            @NotNull
            public Iterator<SegmentId> iterator() {
                return new AbstractIterator<SegmentId>(){
                    private int reference = 1;

                    protected SegmentId computeNext() {
                        if (this.reference <= referencedSegmentIdCount) {
                            return this.getSegmentId(this.reference++);
                        }
                        return (SegmentId)this.endOfData();
                    }
                };
            }
        };
    }

    public SegmentId getSegmentId(int var1);
}

