/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.segment.Cache;
import org.apache.jackrabbit.oak.segment.MapEntry;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordWriters;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentStream;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSegmentWriter
implements SegmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSegmentWriter.class);
    private static final int CHILD_NODE_UPDATE_LIMIT = Integer.getInteger("child.node.update.limit", 10000);
    protected static final String MAX_MAP_RECORD_SIZE_KEY = "oak.segmentNodeStore.maxMapRecordSize";
    @NotNull
    private final WriterCacheManager cacheManager;
    @NotNull
    private final SegmentStore store;
    @NotNull
    private final SegmentReader reader;
    @NotNull
    private final SegmentIdProvider idProvider;
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final WriteOperationHandler writeOperationHandler;
    private final int binariesInlineThreshold;

    public DefaultSegmentWriter(@NotNull SegmentStore store, @NotNull SegmentReader reader, @NotNull SegmentIdProvider idProvider, @Nullable BlobStore blobStore, @NotNull WriterCacheManager cacheManager, @NotNull WriteOperationHandler writeOperationHandler, int binariesInlineThreshold) {
        this.store = Objects.requireNonNull(store);
        this.reader = Objects.requireNonNull(reader);
        this.idProvider = Objects.requireNonNull(idProvider);
        this.blobStore = blobStore;
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.writeOperationHandler = Objects.requireNonNull(writeOperationHandler);
        Validate.checkArgument((binariesInlineThreshold >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((binariesInlineThreshold <= 16512 ? 1 : 0) != 0);
        this.binariesInlineThreshold = binariesInlineThreshold;
    }

    @Override
    public void flush() throws IOException {
        this.writeOperationHandler.flush(this.store);
    }

    @NotNull
    RecordId writeMap(@Nullable MapRecord base, @NotNull Map<String, RecordId> changes) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeMap(base, changes);
    }

    @NotNull
    RecordId writeList(@NotNull List<RecordId> list) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeList(list);
    }

    @NotNull
    RecordId writeString(@NotNull String string) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeString(string);
    }

    @Override
    @NotNull
    public RecordId writeBlob(@NotNull Blob blob) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeBlob(blob);
    }

    @NotNull
    RecordId writeBlock(@NotNull byte[] bytes, int offset, int length) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeBlock(bytes, offset, length);
    }

    @Override
    @NotNull
    public RecordId writeStream(@NotNull InputStream stream) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeStream(stream);
    }

    @NotNull
    RecordId writeProperty(@NotNull PropertyState state) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeProperty(state);
    }

    @Override
    @NotNull
    public RecordId writeNode(@NotNull NodeState state, @Nullable Buffer stableIdBytes) throws IOException {
        return new SegmentWriteOperation(this.writeOperationHandler.getGCGeneration()).writeNode(state, stableIdBytes);
    }

    private class SegmentWriteOperation {
        private final GCGeneration gcGeneration;
        private final Cache<String, RecordId> stringCache;
        private final Cache<Template, RecordId> templateCache;
        private final Cache<String, RecordId> nodeCache;
        private long lastLogTime;

        SegmentWriteOperation(GCGeneration gcGeneration) {
            int generation = gcGeneration.getGeneration();
            this.gcGeneration = gcGeneration;
            this.stringCache = DefaultSegmentWriter.this.cacheManager.getStringCache(generation);
            this.templateCache = DefaultSegmentWriter.this.cacheManager.getTemplateCache(generation);
            this.nodeCache = DefaultSegmentWriter.this.cacheManager.getNodeCache(generation);
        }

        private WriteOperationHandler.WriteOperation newWriteOperation(RecordWriters.RecordWriter recordWriter) {
            return writer -> recordWriter.write(writer, DefaultSegmentWriter.this.store);
        }

        private boolean shouldLog() {
            long now = System.currentTimeMillis();
            if (now - this.lastLogTime > 1000L) {
                this.lastLogTime = now;
                return true;
            }
            return false;
        }

        private RecordId writeMap(@Nullable MapRecord base, @NotNull Map<String, RecordId> changes) throws IOException {
            MapEntry mapEntry;
            Map.Entry<String, RecordId> change;
            RecordId value;
            if (base != null && base.size() >= 400000000) {
                int maxMapRecordSize = Integer.getInteger(DefaultSegmentWriter.MAX_MAP_RECORD_SIZE_KEY, 0);
                if (base.size() > maxMapRecordSize) {
                    System.setProperty(DefaultSegmentWriter.MAX_MAP_RECORD_SIZE_KEY, String.valueOf(base.size()));
                }
                if (base.size() >= 536000000) {
                    throw new UnsupportedOperationException("Map record has more than 536000000 direct entries. Writing is not allowed. Please remove entries.");
                }
                if (base.size() >= 500000000) {
                    if (!Boolean.getBoolean("oak.segmentNodeStore.allowWritesOnHugeMapRecord")) {
                        if (this.shouldLog()) {
                            LOG.error("Map entry has more than {} entries. Writing more than {} entries (up to the hard limit of {}) is only allowed if the system property \"oak.segmentNodeStore.allowWritesOnHugeMapRecord\" is set", new Object[]{450000000, 500000000, 536000000});
                        }
                        throw new UnsupportedOperationException("Map record has more than 500000000 direct entries. Writing is not allowed. Please remove entries.");
                    }
                } else if (base.size() >= 450000000) {
                    if (this.shouldLog()) {
                        LOG.error("Map entry has more than {} entries. Please remove entries.", (Object)450000000);
                    }
                } else if (this.shouldLog()) {
                    LOG.warn("Map entry has more than {} entries. Please remove entries.", (Object)400000000);
                }
            }
            if (base != null && base.isDiff()) {
                Segment segment = base.getSegment();
                RecordId key = segment.readRecordId(base.getRecordNumber(), 8);
                String string = DefaultSegmentWriter.this.reader.readString(key);
                if (!changes.containsKey(string)) {
                    changes.put(string, segment.readRecordId(base.getRecordNumber(), 8, 1));
                }
                base = new MapRecord(DefaultSegmentWriter.this.reader, segment.readRecordId(base.getRecordNumber(), 8, 2));
            }
            if (base != null && changes.size() == 1 && (value = (change = changes.entrySet().iterator().next()).getValue()) != null && (mapEntry = base.getEntry(change.getKey())) != null) {
                if (value.equals(mapEntry.getValue())) {
                    return base.getRecordId();
                }
                return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newMapBranchWriter(mapEntry.getHash(), Arrays.asList(mapEntry.getKey(), value, base.getRecordId()))));
            }
            ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
            for (Map.Entry<String, RecordId> entry : changes.entrySet()) {
                MapEntry e;
                String key = entry.getKey();
                RecordId keyId = null;
                if (base != null && (e = base.getEntry(key)) != null) {
                    keyId = e.getKey();
                }
                if (keyId == null && entry.getValue() != null) {
                    keyId = this.writeString(key);
                }
                if (keyId == null) continue;
                entries.add(MapEntry.newModifiedMapEntry(DefaultSegmentWriter.this.reader, key, keyId, entry.getValue()));
            }
            return this.writeMapBucket(base, entries, 0);
        }

        private RecordId writeMapLeaf(int level, Collection<MapEntry> entries) throws IOException {
            Objects.requireNonNull(entries);
            int size = entries.size();
            Objects.checkIndex(size, MapRecord.MAX_SIZE);
            Objects.checkIndex(level, 8);
            Validate.checkArgument((size != 0 || level == 7 ? 1 : 0) != 0);
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newMapLeafWriter(level, entries)));
        }

        private RecordId writeMapBranch(int level, int size, MapRecord ... buckets) throws IOException {
            Objects.checkIndex(size, MapRecord.MAX_SIZE);
            int bitmap = 0;
            ArrayList<RecordId> bucketIds = new ArrayList<RecordId>(buckets.length);
            for (int i = 0; i < buckets.length; ++i) {
                if (buckets[i] == null) continue;
                bitmap = (int)((long)bitmap | 1L << i);
                bucketIds.add(buckets[i].getRecordId());
            }
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newMapBranchWriter(level, size, bitmap, bucketIds)));
        }

        private RecordId writeMapBucket(MapRecord base, Collection<MapEntry> entries, int level) throws IOException {
            if (entries == null || entries.isEmpty()) {
                if (base != null) {
                    return base.getRecordId();
                }
                if (level == 0) {
                    return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newMapLeafWriter()));
                }
                return null;
            }
            if (base == null) {
                if (entries.size() <= 32 || level == 7) {
                    return this.writeMapLeaf(level, entries);
                }
                MapRecord[] buckets = new MapRecord[32];
                List<List<MapEntry>> changes = this.splitToBuckets(entries, level);
                for (int i = 0; i < 32; ++i) {
                    buckets[i] = this.mapRecordOrNull(this.writeMapBucket(null, (Collection<MapEntry>)changes.get(i), level + 1));
                }
                return this.writeMapBranch(level, entries.size(), buckets);
            }
            if (base.isLeaf()) {
                HashMap<String, MapEntry> map = new HashMap<String, MapEntry>();
                for (MapEntry entry : base.getEntries()) {
                    map.put(entry.getName(), entry);
                }
                for (MapEntry entry : entries) {
                    if (entry.isDeleted()) {
                        map.remove(entry.getName());
                        continue;
                    }
                    map.put(entry.getName(), entry);
                }
                return this.writeMapBucket(null, map.values(), level);
            }
            int newSize = 0;
            int newCount = 0;
            MapRecord[] buckets = base.getBuckets();
            List<List<MapEntry>> changes = this.splitToBuckets(entries, level);
            for (int i = 0; i < 32; ++i) {
                buckets[i] = this.mapRecordOrNull(this.writeMapBucket(buckets[i], (Collection<MapEntry>)changes.get(i), level + 1));
                if (buckets[i] == null) continue;
                newSize += buckets[i].size();
                ++newCount;
            }
            if (newSize > 32) {
                return this.writeMapBranch(level, newSize, buckets);
            }
            if (newCount <= 1) {
                for (MapRecord bucket : buckets) {
                    if (bucket == null) continue;
                    return bucket.getRecordId();
                }
                return this.writeMapBucket(null, null, level);
            }
            ArrayList<MapEntry> list = new ArrayList<MapEntry>();
            for (MapRecord bucket : buckets) {
                if (bucket == null) continue;
                bucket.getEntries().forEach(list::add);
            }
            return this.writeMapLeaf(level, list);
        }

        private MapRecord mapRecordOrNull(RecordId id) {
            return id == null ? null : new MapRecord(DefaultSegmentWriter.this.reader, id);
        }

        private RecordId writeList(@NotNull List<RecordId> list) throws IOException {
            Objects.requireNonNull(list);
            Validate.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
            List<RecordId> thisLevel = list;
            while (thisLevel.size() > 1) {
                ArrayList<RecordId> nextLevel = new ArrayList<RecordId>();
                for (List bucket : ListUtils.partitionList(thisLevel, (int)255)) {
                    if (bucket.size() > 1) {
                        nextLevel.add(this.writeListBucket(bucket));
                        continue;
                    }
                    nextLevel.add((RecordId)bucket.get(0));
                }
                thisLevel = nextLevel;
            }
            return thisLevel.iterator().next();
        }

        private RecordId writeListBucket(List<RecordId> bucket) throws IOException {
            Validate.checkArgument((bucket.size() > 1 ? 1 : 0) != 0);
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newListBucketWriter(bucket)));
        }

        private List<List<MapEntry>> splitToBuckets(Collection<MapEntry> entries, int level) {
            int mask = 31;
            int shift = 32 - (level + 1) * 5;
            ArrayList<List<MapEntry>> buckets = new ArrayList<List<MapEntry>>(Collections.nCopies(32, null));
            for (MapEntry entry : entries) {
                int index = entry.getHash() >> shift & mask;
                ArrayList<MapEntry> bucket = (ArrayList<MapEntry>)buckets.get(index);
                if (bucket == null) {
                    bucket = new ArrayList<MapEntry>();
                    buckets.set(index, bucket);
                }
                bucket.add(entry);
            }
            return buckets;
        }

        private RecordId writeValueRecord(long length, RecordId blocks) throws IOException {
            long len = length - 16512L | 0xC000000000000000L;
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newValueWriter(blocks, len)));
        }

        private RecordId writeValueRecord(int length, byte ... data) throws IOException {
            Validate.checkArgument((length < 16512 ? 1 : 0) != 0);
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newValueWriter(length, data)));
        }

        private RecordId writeString(@NotNull String string) throws IOException {
            RecordId id = this.stringCache.get(string);
            if (id != null) {
                return id;
            }
            byte[] data = string.getBytes(StandardCharsets.UTF_8);
            if (data.length < 16512) {
                id = this.writeValueRecord(data.length, data);
                this.stringCache.put(string, id);
                return id;
            }
            int pos = 0;
            ArrayList<RecordId> blockIds = new ArrayList<RecordId>(data.length / 4096 + 1);
            while (pos + 262144 <= data.length) {
                SegmentId bulkId = DefaultSegmentWriter.this.idProvider.newBulkSegmentId();
                DefaultSegmentWriter.this.store.writeSegment(bulkId, data, pos, 262144);
                for (int i = 0; i < 262144; i += 4096) {
                    blockIds.add(new RecordId(bulkId, i));
                }
                pos += 262144;
            }
            while (pos < data.length) {
                int len = Math.min(4096, data.length - pos);
                blockIds.add(this.writeBlock(data, pos, len));
                pos += len;
            }
            return this.writeValueRecord((long)data.length, this.writeList(blockIds));
        }

        private boolean sameStore(SegmentId id) {
            return id.sameStore(DefaultSegmentWriter.this.store);
        }

        private boolean sameStore(Blob blob) {
            return blob instanceof SegmentBlob && this.sameStore(((Record)blob).getRecordId().getSegmentId());
        }

        private RecordId writeBlob(@NotNull Blob blob) throws IOException {
            String blobId;
            if (this.sameStore(blob)) {
                SegmentBlob segmentBlob = (SegmentBlob)blob;
                if (!this.isOldGeneration(segmentBlob.getRecordId())) {
                    return segmentBlob.getRecordId();
                }
                if (segmentBlob.isExternal()) {
                    return this.writeBlobId(segmentBlob.getBlobId());
                }
            }
            if (blob instanceof BlobStoreBlob && (blobId = ((BlobStoreBlob)blob).getBlobId()) != null) {
                return this.writeBlobId(blobId);
            }
            String reference = blob.getReference();
            if (reference != null && DefaultSegmentWriter.this.blobStore != null) {
                String blobId2 = DefaultSegmentWriter.this.blobStore.getBlobId(reference);
                if (blobId2 != null) {
                    return this.writeBlobId(blobId2);
                }
                LOG.debug("No blob found for reference {}, inlining...", (Object)reference);
            }
            return this.writeStream(blob.getNewStream());
        }

        private RecordId writeBlobId(String blobId) throws IOException {
            byte[] data = blobId.getBytes(StandardCharsets.UTF_8);
            if (data.length < 4096) {
                return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newBlobIdWriter(data)));
            }
            RecordId refId = this.writeString(blobId);
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newBlobIdWriter(refId)));
        }

        private RecordId writeBlock(@NotNull byte[] bytes, int offset, int length) throws IOException {
            Objects.requireNonNull(bytes);
            Objects.checkFromToIndex(offset, offset + length, bytes.length);
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newBlockWriter(bytes, offset, length)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RecordId writeStream(@NotNull InputStream stream) throws IOException {
            boolean threw = true;
            try {
                RecordId id = SegmentStream.getRecordIdIfAvailable(stream, DefaultSegmentWriter.this.store);
                if (id == null) {
                    id = this.internalWriteStream(stream);
                } else if (this.isOldGeneration(id)) {
                    SegmentStream segmentStream = (SegmentStream)stream;
                    List<RecordId> blockIds = segmentStream.getBlockIds();
                    if (blockIds == null) {
                        RecordId recordId = this.internalWriteStream(stream);
                        return recordId;
                    }
                    RecordId recordId = this.writeValueRecord(segmentStream.getLength(), this.writeList(blockIds));
                    return recordId;
                }
                threw = false;
                RecordId recordId = id;
                return recordId;
            }
            finally {
                try {
                    IOUtils.close((Closeable)stream);
                }
                catch (IOException ex) {
                    if (!threw) {
                        throw ex;
                    }
                    LOG.warn("IOException thrown while closing stream", (Throwable)ex);
                }
            }
        }

        private RecordId internalWriteStream(@NotNull InputStream stream) throws IOException {
            byte[] data = new byte[DefaultSegmentWriter.this.binariesInlineThreshold];
            int n = IOUtils.read((InputStream)stream, (byte[])data, (int)0, (int)data.length);
            if (n < DefaultSegmentWriter.this.binariesInlineThreshold) {
                return this.writeValueRecord(n, data);
            }
            if (DefaultSegmentWriter.this.blobStore != null) {
                String blobId = DefaultSegmentWriter.this.blobStore.writeBlob((InputStream)new SequenceInputStream(new ByteArrayInputStream(data, 0, n), stream));
                return this.writeBlobId(blobId);
            }
            if ((n += IOUtils.read((InputStream)stream, (byte[])(data = Arrays.copyOf(data, 16512)), (int)n, (int)(16512 - n))) < 16512) {
                return this.writeValueRecord(n, data);
            }
            data = Arrays.copyOf(data, 262144);
            n += IOUtils.read((InputStream)stream, (byte[])data, (int)n, (int)(262144 - n));
            long length = n;
            ArrayList<RecordId> blockIds = new ArrayList<RecordId>(2 * n / 4096);
            while (n != 0) {
                SegmentId bulkId = DefaultSegmentWriter.this.idProvider.newBulkSegmentId();
                LOG.debug("Writing bulk segment {} ({} bytes)", (Object)bulkId, (Object)n);
                DefaultSegmentWriter.this.store.writeSegment(bulkId, data, 0, n);
                for (int i = 0; i < n; i += 4096) {
                    blockIds.add(new RecordId(bulkId, data.length - n + i));
                }
                n = IOUtils.read((InputStream)stream, (byte[])data, (int)0, (int)data.length);
                length += (long)n;
            }
            return this.writeValueRecord(length, this.writeList(blockIds));
        }

        private RecordId writeProperty(@NotNull PropertyState state) throws IOException {
            Map<String, RecordId> previousValues = Collections.emptyMap();
            return this.writeProperty(state, previousValues);
        }

        private RecordId writeProperty(@NotNull PropertyState state, @NotNull Map<String, RecordId> previousValues) throws IOException {
            Type type = state.getType();
            int count = state.count();
            ArrayList<RecordId> valueIds = new ArrayList<RecordId>();
            for (int i = 0; i < count; ++i) {
                if (type.tag() == 2) {
                    try {
                        valueIds.add(this.writeBlob((Blob)state.getValue(Type.BINARY, i)));
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unexpected IOException", e);
                    }
                }
                String value = (String)state.getValue(Type.STRING, i);
                RecordId valueId = previousValues.get(value);
                if (valueId == null) {
                    valueId = this.writeString(value);
                }
                valueIds.add(valueId);
            }
            if (!type.isArray()) {
                return (RecordId)valueIds.iterator().next();
            }
            if (count == 0) {
                return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newListWriter()));
            }
            RecordId lid = this.writeList(valueIds);
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newListWriter(count, lid)));
        }

        private RecordId writeTemplate(Template template) throws IOException {
            Objects.requireNonNull(template);
            RecordId id = this.templateCache.get(template);
            if (id != null) {
                return id;
            }
            ArrayList<RecordId> ids = new ArrayList<RecordId>();
            int head = 0;
            RecordId primaryId = null;
            PropertyState primaryType = template.getPrimaryType();
            if (primaryType != null) {
                head |= Integer.MIN_VALUE;
                primaryId = this.writeString((String)primaryType.getValue(Type.NAME));
                ids.add(primaryId);
            }
            ArrayList<RecordId> mixinIds = null;
            PropertyState mixinTypes = template.getMixinTypes();
            if (mixinTypes != null) {
                head |= 0x40000000;
                mixinIds = new ArrayList<RecordId>();
                for (String mixin : (Iterable)mixinTypes.getValue(Type.NAMES)) {
                    mixinIds.add(this.writeString(mixin));
                }
                ids.addAll(mixinIds);
                Validate.checkState((mixinIds.size() < 1024 ? 1 : 0) != 0);
                head |= mixinIds.size() << 18;
            }
            RecordId childNameId = null;
            String childName = template.getChildName();
            if (childName == Template.ZERO_CHILD_NODES) {
                head |= 0x20000000;
            } else if (childName == "") {
                head |= 0x10000000;
            } else {
                childNameId = this.writeString(childName);
                ids.add(childNameId);
            }
            PropertyTemplate[] properties = template.getPropertyTemplates();
            RecordId[] propertyNames = new RecordId[properties.length];
            byte[] propertyTypes = new byte[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                propertyNames[i] = this.writeString(properties[i].getName());
                Type<?> type = properties[i].getType();
                propertyTypes[i] = type.isArray() ? (byte)(-type.tag()) : (byte)type.tag();
            }
            RecordId propNamesId = null;
            if (propertyNames.length > 0) {
                propNamesId = this.writeList(Arrays.asList(propertyNames));
                ids.add(propNamesId);
            }
            Validate.checkState((propertyNames.length < 262144 ? 1 : 0) != 0);
            RecordId tid = DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newTemplateWriter(ids, propertyNames, propertyTypes, head |= propertyNames.length, primaryId, mixinIds, childNameId, propNamesId)));
            this.templateCache.put(template, tid);
            return tid;
        }

        private RecordId writeNode(@NotNull NodeState state, @Nullable Buffer stableIdBytes) throws IOException {
            RecordId compactedId = this.deduplicateNode(state);
            if (compactedId != null) {
                return compactedId;
            }
            if (state instanceof SegmentNodeState && stableIdBytes == null) {
                stableIdBytes = ((SegmentNodeState)state).getStableIdBytes();
            }
            RecordId recordId = this.writeNodeUncached(state, stableIdBytes);
            if (stableIdBytes != null) {
                this.nodeCache.put(SegmentNodeState.getStableId(stableIdBytes), recordId, this.cost(state));
            }
            return recordId;
        }

        private byte cost(NodeState node) {
            long childCount = node.getChildNodeCount(Long.MAX_VALUE);
            return (byte)(-64 - Long.numberOfLeadingZeros(childCount));
        }

        private RecordId writeNodeUncached(@NotNull NodeState state, @Nullable Buffer stableIdBytes) throws IOException {
            RecordId stableId;
            RecordId beforeId = null;
            if (state instanceof ModifiedNodeState) {
                beforeId = this.deduplicateNode(((ModifiedNodeState)state).getBaseState());
            }
            SegmentNodeState before = null;
            Template beforeTemplate = null;
            if (beforeId != null) {
                before = DefaultSegmentWriter.this.reader.readNode(beforeId);
                beforeTemplate = before.getTemplate();
            }
            ArrayList<RecordId> ids = new ArrayList<RecordId>();
            Template template = new Template(DefaultSegmentWriter.this.reader, state);
            if (template.equals(beforeTemplate)) {
                ids.add(before.getTemplateId());
            } else {
                ids.add(this.writeTemplate(template));
            }
            String childName = template.getChildName();
            if (childName == "") {
                ids.add(this.writeChildNodes(before, state));
            } else if (childName != Template.ZERO_CHILD_NODES) {
                ids.add(this.writeNode(state.getChildNode(template.getChildName()), null));
            }
            ArrayList<RecordId> pIds = new ArrayList<RecordId>();
            for (PropertyTemplate pt : template.getPropertyTemplates()) {
                PropertyState beforeProperty;
                String name = pt.getName();
                PropertyState property = state.getProperty(name);
                assert (property != null);
                if (before != null && property.equals(beforeProperty = before.getProperty(name))) {
                    property = beforeProperty;
                }
                if (this.sameStore(property)) {
                    RecordId pid = ((Record)property).getRecordId();
                    if (this.isOldGeneration(pid)) {
                        pIds.add(this.writeProperty(property));
                        continue;
                    }
                    pIds.add(pid);
                    continue;
                }
                if (before == null || !this.sameStore(before)) {
                    pIds.add(this.writeProperty(property));
                    continue;
                }
                PropertyTemplate bt = beforeTemplate.getPropertyTemplate(name);
                if (bt == null) {
                    pIds.add(this.writeProperty(property));
                    continue;
                }
                SegmentPropertyState bp = beforeTemplate.getProperty(before.getRecordId(), bt.getIndex());
                if (property.equals(bp)) {
                    pIds.add(bp.getRecordId());
                    continue;
                }
                if (bp.isArray() && bp.getType() != Type.BINARIES) {
                    pIds.add(this.writeProperty(property, bp.getValueRecords()));
                    continue;
                }
                pIds.add(this.writeProperty(property));
            }
            if (!pIds.isEmpty()) {
                ids.add(this.writeList(pIds));
            }
            if (stableIdBytes != null) {
                Buffer buffer = stableIdBytes.duplicate();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                stableId = this.writeBlock(bytes, 0, bytes.length);
            } else {
                stableId = null;
            }
            return DefaultSegmentWriter.this.writeOperationHandler.execute(this.gcGeneration, this.newWriteOperation(RecordWriters.newNodeStateWriter(stableId, ids)));
        }

        @NotNull
        private RecordId writeChildNodes(@Nullable SegmentNodeState before, @NotNull NodeState after) throws IOException {
            if (before != null && before.getChildNodeCount(2L) > 1L && after.getChildNodeCount(2L) > 1L) {
                return new ChildNodeCollectorDiff(before.getChildNodeMap()).diff(before, after);
            }
            return new ChildNodeCollectorDiff().diff(after);
        }

        @Nullable
        private RecordId deduplicateNode(@NotNull NodeState node) {
            if (!(node instanceof SegmentNodeState)) {
                return null;
            }
            SegmentNodeState sns = (SegmentNodeState)node;
            if (!this.sameStore(sns)) {
                return null;
            }
            if (!this.isOldGeneration(sns.getRecordId())) {
                return sns.getRecordId();
            }
            return this.nodeCache.get(sns.getStableId());
        }

        private boolean sameStore(SegmentNodeState node) {
            return this.sameStore(node.getRecordId().getSegmentId());
        }

        private boolean sameStore(PropertyState property) {
            return property instanceof SegmentPropertyState && this.sameStore(((Record)property).getRecordId().getSegmentId());
        }

        private boolean isOldGeneration(RecordId id) {
            try {
                GCGeneration thatGen = id.getSegmentId().getGcGeneration();
                GCGeneration thisGen = this.gcGeneration;
                if (thatGen.isCompacted()) {
                    return thatGen.getFullGeneration() < thisGen.getFullGeneration();
                }
                return thatGen.compareWith(thisGen) < 0;
            }
            catch (SegmentNotFoundException snfe) {
                throw new SegmentNotFoundException("Cannot copy record from a generation that has been gc'ed already", snfe);
            }
        }

        private class ChildNodeCollectorDiff
        extends DefaultNodeStateDiff {
            private final Map<String, RecordId> childNodes = new HashMap<String, RecordId>();
            @Nullable
            private MapRecord base;
            private IOException exception;

            private ChildNodeCollectorDiff(MapRecord base) {
                this.base = base;
            }

            private ChildNodeCollectorDiff() {
                this(null);
            }

            public RecordId diff(NodeState after) throws IOException {
                EmptyNodeState.compareAgainstEmptyState((NodeState)after, (NodeStateDiff)this);
                if (this.exception != null) {
                    throw new IOException(this.exception);
                }
                return this.flush();
            }

            public RecordId diff(NodeState before, NodeState after) throws IOException {
                after.compareAgainstBaseState(before, (NodeStateDiff)this);
                if (this.exception != null) {
                    throw new IOException(this.exception);
                }
                return this.flush();
            }

            public boolean childNodeAdded(String name, NodeState after) {
                try {
                    this.onChildNode(name, SegmentWriteOperation.this.writeNode(after, null));
                }
                catch (IOException e) {
                    this.exception = e;
                    return false;
                }
                return true;
            }

            public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                try {
                    this.onChildNode(name, SegmentWriteOperation.this.writeNode(after, null));
                }
                catch (IOException e) {
                    this.exception = e;
                    return false;
                }
                return true;
            }

            public boolean childNodeDeleted(String name, NodeState before) {
                try {
                    this.onChildNode(name, null);
                }
                catch (IOException e) {
                    this.exception = e;
                    return false;
                }
                return true;
            }

            private void onChildNode(String nodeName, @Nullable RecordId recordId) throws IOException {
                this.childNodes.put(nodeName, recordId);
                if (this.childNodes.size() > CHILD_NODE_UPDATE_LIMIT) {
                    this.flush();
                }
            }

            private RecordId flush() throws IOException {
                RecordId mapId = SegmentWriteOperation.this.writeMap(this.base, this.childNodes);
                this.base = DefaultSegmentWriter.this.reader.readMap(mapId);
                this.childNodes.clear();
                return mapId;
            }
        }
    }
}

