/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.jcr.observation.EventFactory;
import org.apache.jackrabbit.oak.jcr.observation.EventQueue;
import org.apache.jackrabbit.oak.namepath.PathTracker;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierTracker;
import org.apache.jackrabbit.oak.plugins.observation.DefaultEventHandler;
import org.apache.jackrabbit.oak.plugins.observation.EventHandler;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class QueueingHandler
extends DefaultEventHandler {
    private final EventQueue queue;
    private final EventFactory factory;
    private final PathTracker pathTracker;
    private final String parentType;
    private final Iterable<String> parentMixins;
    private final IdentifierTracker beforeIdentifierTracker;
    private final IdentifierTracker identifierTracker;

    QueueingHandler(EventQueue queue, EventFactory factory, NodeState before, NodeState after) {
        this.queue = queue;
        this.factory = factory;
        this.pathTracker = new PathTracker();
        this.beforeIdentifierTracker = new IdentifierTracker(before);
        if (after.exists()) {
            this.identifierTracker = new IdentifierTracker(after);
            this.parentType = QueueingHandler.getPrimaryType(after);
            this.parentMixins = QueueingHandler.getMixinTypes(after);
        } else {
            this.identifierTracker = this.beforeIdentifierTracker;
            this.parentType = QueueingHandler.getPrimaryType(before);
            this.parentMixins = QueueingHandler.getMixinTypes(before);
        }
    }

    private QueueingHandler(QueueingHandler parent, String name, NodeState before, NodeState after) {
        this.queue = parent.queue;
        this.factory = parent.factory;
        this.pathTracker = parent.pathTracker.getChildTracker(name);
        this.beforeIdentifierTracker = parent.beforeIdentifierTracker.getChildTracker(name, before);
        if (after.exists()) {
            this.identifierTracker = parent.identifierTracker.getChildTracker(name, after);
            this.parentType = QueueingHandler.getPrimaryType(after);
            this.parentMixins = QueueingHandler.getMixinTypes(after);
        } else {
            this.identifierTracker = this.beforeIdentifierTracker;
            this.parentType = QueueingHandler.getPrimaryType(before);
            this.parentMixins = QueueingHandler.getMixinTypes(before);
        }
    }

    public EventHandler getChildHandler(String name, NodeState before, NodeState after) {
        return new QueueingHandler(this, name, before, after);
    }

    public void propertyAdded(PropertyState after) {
        this.queue.addEvent(this.factory.propertyAdded(after, this.parentType, this.parentMixins, this.pathTracker.getPath(), after.getName(), this.identifierTracker.getIdentifier()));
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
        this.queue.addEvent(this.factory.propertyChanged(before, after, this.parentType, this.parentMixins, this.pathTracker.getPath(), after.getName(), this.identifierTracker.getIdentifier()));
    }

    public void propertyDeleted(PropertyState before) {
        this.queue.addEvent(this.factory.propertyDeleted(before, this.parentType, this.parentMixins, this.pathTracker.getPath(), before.getName(), this.identifierTracker.getIdentifier()));
    }

    public void nodeAdded(String name, NodeState after) {
        IdentifierTracker tracker = this.identifierTracker.getChildTracker(name, after);
        this.queue.addEvent(this.factory.nodeAdded(QueueingHandler.getPrimaryType(after), QueueingHandler.getMixinTypes(after), this.pathTracker.getPath(), name, tracker.getIdentifier()));
    }

    public void nodeDeleted(String name, NodeState before) {
        IdentifierTracker tracker = this.beforeIdentifierTracker.getChildTracker(name, before);
        this.queue.addEvent(this.factory.nodeDeleted(QueueingHandler.getPrimaryType(before), QueueingHandler.getMixinTypes(before), this.pathTracker.getPath(), name, tracker.getIdentifier()));
    }

    public void nodeMoved(String sourcePath, String name, NodeState moved) {
        IdentifierTracker tracker = this.identifierTracker.getChildTracker(name, moved);
        this.queue.addEvent(this.factory.nodeMoved(QueueingHandler.getPrimaryType(moved), QueueingHandler.getMixinTypes(moved), this.pathTracker.getPath(), name, tracker.getIdentifier(), sourcePath));
    }

    public void nodeReordered(String destName, String name, NodeState reordered) {
        IdentifierTracker tracker = this.identifierTracker.getChildTracker(name, reordered);
        this.queue.addEvent(this.factory.nodeReordered(QueueingHandler.getPrimaryType(reordered), QueueingHandler.getMixinTypes(reordered), this.pathTracker.getPath(), name, tracker.getIdentifier(), destName));
    }

    private static String getPrimaryType(NodeState before) {
        PropertyState primaryType = before.getProperty("jcr:primaryType");
        if (primaryType != null && primaryType.getType() == Type.NAME) {
            return (String)primaryType.getValue(Type.NAME);
        }
        return null;
    }

    private static Iterable<String> getMixinTypes(NodeState before) {
        PropertyState mixinTypes = before.getProperty("jcr:mixinTypes");
        if (mixinTypes != null && mixinTypes.getType() == Type.NAMES) {
            return (Iterable)mixinTypes.getValue(Type.NAMES);
        }
        return Collections.emptyList();
    }
}

