/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.commons.xml.DocumentViewExporter;
import org.apache.jackrabbit.commons.xml.Exporter;
import org.apache.jackrabbit.commons.xml.ParsingContentHandler;
import org.apache.jackrabbit.commons.xml.SystemViewExporter;
import org.apache.jackrabbit.commons.xml.ToXmlContentHandler;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.ItemDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.ItemImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.PropertyImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.xml.ImportHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SessionImpl
implements JackrabbitSession {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private final SessionContext sessionContext;
    private final SessionDelegate sd;
    private final AtomicLong sessionCounter;

    public SessionImpl(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.sd = sessionContext.getSessionDelegate();
        this.sessionCounter = sessionContext.getCounter(RepositoryStatistics.Type.SESSION_COUNT);
        this.sessionCounter.incrementAndGet();
        sessionContext.getCounter(RepositoryStatistics.Type.SESSION_LOGIN_COUNTER).incrementAndGet();
    }

    static void checkIndexOnName(String jcrPath) throws RepositoryException {
        int pos = jcrPath.length() - 1;
        if (pos < 2 || jcrPath.charAt(pos) != ']') {
            return;
        }
        if ("0123456789".indexOf(jcrPath.charAt(--pos)) == -1) {
            return;
        }
        while (--pos >= 0) {
            char ch = jcrPath.charAt(pos);
            if (ch == '[') {
                throw new RepositoryException("Cannot create a new node using a name including an index");
            }
            if ("0123456789".indexOf(ch) != -1) continue;
            return;
        }
    }

    @CheckForNull
    private <T> T perform(@Nonnull SessionOperation<T> op) throws RepositoryException {
        return this.sd.perform(op);
    }

    @CheckForNull
    private <T> T safePerform(@Nonnull SessionOperation<T> op) {
        return this.sd.safePerform(op);
    }

    @Nonnull
    private String getOakPathOrThrow(@Nonnull String absPath) throws RepositoryException {
        String p = this.sessionContext.getOakPathOrThrow(absPath);
        if (!PathUtils.isAbsolute((String)p)) {
            throw new RepositoryException("Not an absolute path: " + absPath);
        }
        return p;
    }

    @Nonnull
    private String getOakPathOrThrowNotFound(@Nonnull String absPath) throws PathNotFoundException {
        return this.sessionContext.getOakPathOrThrowNotFound(absPath);
    }

    @CheckForNull
    private ItemImpl<?> getItemInternal(@Nonnull String oakPath) throws RepositoryException {
        ItemDelegate item = this.sd.getItem(oakPath);
        if (item instanceof NodeDelegate) {
            return NodeImpl.createNodeOrNull((NodeDelegate)item, this.sessionContext);
        }
        if (item instanceof PropertyDelegate) {
            return new PropertyImpl((PropertyDelegate)item, this.sessionContext);
        }
        return null;
    }

    @CheckForNull
    public Node getNodeOrNull(final String absPath) throws RepositoryException {
        Preconditions.checkNotNull((Object)absPath);
        return this.perform(new ReadOperation<Node>("getNodeOrNull"){

            @Override
            public Node perform() throws RepositoryException {
                try {
                    return NodeImpl.createNodeOrNull(SessionImpl.this.sd.getNode(SessionImpl.this.getOakPathOrThrow(absPath)), SessionImpl.this.sessionContext);
                }
                catch (PathNotFoundException e) {
                    return null;
                }
            }
        });
    }

    @CheckForNull
    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        String oakPath;
        if (((String)Preconditions.checkNotNull((Object)absPath)).equals("/")) {
            return null;
        }
        try {
            oakPath = this.getOakPathOrThrow(absPath);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        return this.perform(new ReadOperation<Property>("getPropertyOrNull"){

            @Override
            public Property perform() throws RepositoryException {
                PropertyDelegate pd = SessionImpl.this.sd.getProperty(oakPath);
                if (pd != null) {
                    return new PropertyImpl(pd, SessionImpl.this.sessionContext);
                }
                return null;
            }
        });
    }

    @CheckForNull
    public Item getItemOrNull(final String absPath) throws RepositoryException {
        Preconditions.checkNotNull((Object)absPath);
        return this.perform(new ReadOperation<Item>("getItemOrNull"){

            @Override
            public Item perform() throws RepositoryException {
                return SessionImpl.this.getItemInternal(SessionImpl.this.getOakPathOrThrow(absPath));
            }
        });
    }

    @Nonnull
    public Repository getRepository() {
        return this.sessionContext.getRepository();
    }

    public String getUserID() {
        return this.sd.getAuthInfo().getUserID();
    }

    public String[] getAttributeNames() {
        TreeSet names = Sets.newTreeSet(this.sessionContext.getAttributes().keySet());
        Collections.addAll(names, this.sd.getAuthInfo().getAttributeNames());
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String name) {
        Object attribute = this.sd.getAuthInfo().getAttribute(name);
        if (attribute == null) {
            attribute = this.sessionContext.getAttributes().get(name);
        }
        return attribute;
    }

    @Nonnull
    public Workspace getWorkspace() {
        return this.sessionContext.getWorkspace();
    }

    @Nonnull
    public Session impersonate(Credentials credentials) throws RepositoryException {
        this.sd.checkAlive();
        ImpersonationCredentials impCreds = new ImpersonationCredentials((Credentials)Preconditions.checkNotNull((Object)credentials), this.sd.getAuthInfo());
        return this.getRepository().login((Credentials)impCreds, this.sd.getWorkspaceName());
    }

    @Nonnull
    public ValueFactory getValueFactory() throws RepositoryException {
        this.sd.checkAlive();
        return this.sessionContext.getValueFactory();
    }

    @Nonnull
    public Node getRootNode() throws RepositoryException {
        return this.perform(new ReadOperation<Node>("getRootNode"){

            @Override
            public Node perform() throws RepositoryException {
                NodeDelegate nd = SessionImpl.this.sd.getRootNode();
                if (nd == null) {
                    throw new AccessDeniedException("Root node is not accessible.");
                }
                return NodeImpl.createNodeOrNull(nd, SessionImpl.this.sessionContext);
            }
        });
    }

    public Node getNode(String absPath) throws RepositoryException {
        Node node = this.getNodeOrNull((String)Preconditions.checkNotNull((Object)absPath));
        if (node == null) {
            throw new PathNotFoundException("Node with path " + absPath + " does not exist.");
        }
        return node;
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.getNodeOrNull((String)Preconditions.checkNotNull((Object)absPath)) != null;
    }

    @Nonnull
    private Node getNodeById(final @Nonnull String id) throws RepositoryException {
        return this.perform(new ReadOperation<Node>("getNodeById"){

            @Override
            public Node perform() throws RepositoryException {
                NodeDelegate nd = SessionImpl.this.sd.getNodeByIdentifier(id);
                if (nd == null) {
                    throw new ItemNotFoundException("Node with id " + id + " does not exist.");
                }
                return NodeImpl.createNodeOrNull(nd, SessionImpl.this.sessionContext);
            }
        });
    }

    @Nonnull
    public Node getNodeByUUID(String uuid) throws RepositoryException {
        return this.getNodeById((String)Preconditions.checkNotNull((Object)uuid));
    }

    @Nonnull
    public Node getNodeByIdentifier(String id) throws RepositoryException {
        return this.getNodeById((String)Preconditions.checkNotNull((Object)id));
    }

    public Property getProperty(String absPath) throws RepositoryException {
        Property property = this.getPropertyOrNull((String)Preconditions.checkNotNull((Object)absPath));
        if (property == null) {
            throw new PathNotFoundException(absPath);
        }
        return property;
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.getPropertyOrNull((String)Preconditions.checkNotNull((Object)absPath)) != null;
    }

    public Item getItem(String absPath) throws RepositoryException {
        Item item = this.getItemOrNull((String)Preconditions.checkNotNull((Object)absPath));
        if (item == null) {
            throw new PathNotFoundException(absPath);
        }
        return item;
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        return this.getItemOrNull((String)Preconditions.checkNotNull((Object)absPath)) != null;
    }

    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        SessionImpl.checkIndexOnName((String)Preconditions.checkNotNull((Object)destAbsPath));
        final String srcOakPath = this.getOakPathOrThrowNotFound((String)Preconditions.checkNotNull((Object)srcAbsPath));
        final String destOakPath = this.getOakPathOrThrowNotFound(destAbsPath);
        this.sd.perform(new WriteOperation<Void>("move"){

            @Override
            public void checkPreconditions() throws RepositoryException {
                super.checkPreconditions();
                SessionImpl.this.sd.checkProtectedNode(PathUtils.getParentPath((String)srcOakPath));
                SessionImpl.this.sd.checkProtectedNode(PathUtils.getParentPath((String)destOakPath));
            }

            @Override
            public Void perform() throws RepositoryException {
                SessionImpl.this.sd.move(srcOakPath, destOakPath, true);
                return null;
            }
        });
    }

    public void removeItem(final String absPath) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrowNotFound((String)Preconditions.checkNotNull((Object)absPath));
        this.perform(new WriteOperation<Void>("removeItem"){

            @Override
            public Void perform() throws RepositoryException {
                ItemDelegate item = SessionImpl.this.sd.getItem(oakPath);
                if (item == null) {
                    throw new PathNotFoundException(absPath);
                }
                if (item.isProtected()) {
                    throw new ConstraintViolationException(item.getPath() + " is protected");
                }
                if (item.remove()) {
                    return null;
                }
                throw new RepositoryException(item.getPath() + " could not be removed");
            }
        });
    }

    public void save() throws RepositoryException {
        this.perform(new WriteOperation<Void>("save"){

            @Override
            public Void perform() throws RepositoryException {
                SessionImpl.this.sd.save(null);
                return null;
            }

            @Override
            public boolean isSave() {
                return true;
            }
        });
    }

    public void refresh(final boolean keepChanges) throws RepositoryException {
        this.perform(new WriteOperation<Void>("refresh"){

            @Override
            public Void perform() {
                SessionImpl.this.sd.refresh(keepChanges);
                return null;
            }

            @Override
            public boolean isRefresh() {
                return true;
            }
        });
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.sd.checkAlive();
        return this.sd.hasPendingChanges();
    }

    public boolean isLive() {
        return this.sd.isAlive();
    }

    public void logout() {
        if (this.sd.isAlive()) {
            this.sessionCounter.decrementAndGet();
            this.safePerform(new SessionOperation<Void>("logout"){

                @Override
                public Void perform() {
                    SessionImpl.this.sessionContext.dispose();
                    SessionImpl.this.sd.logout();
                    return null;
                }

                @Override
                public boolean isLogout() {
                    return true;
                }
            });
        }
    }

    @Nonnull
    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        return new ImportHandler((String)Preconditions.checkNotNull((Object)parentAbsPath), this.sessionContext, uuidBehavior, false);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getImportContentHandler((String)Preconditions.checkNotNull((Object)parentAbsPath), uuidBehavior);
            new ParsingContentHandler(handler).parse(in);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new InvalidSerializedDataException("XML parse error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private synchronized void export(String path, Exporter exporter) throws SAXException, RepositoryException {
        Item item = this.getItem(path);
        if (!item.isNode()) {
            throw new PathNotFoundException("XML export is not defined for properties: " + path);
        }
        exporter.export((Node)item);
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.export((String)Preconditions.checkNotNull((Object)absPath), (Exporter)new SystemViewExporter((Session)this, (ContentHandler)Preconditions.checkNotNull((Object)contentHandler), !noRecurse, !skipBinary));
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler((OutputStream)Preconditions.checkNotNull((Object)out));
            this.export((String)Preconditions.checkNotNull((Object)absPath), (Exporter)new SystemViewExporter((Session)this, (ContentHandler)handler, !noRecurse, !skipBinary));
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing system view XML", (Throwable)e);
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
        this.export((String)Preconditions.checkNotNull((Object)absPath), (Exporter)new DocumentViewExporter((Session)this, (ContentHandler)Preconditions.checkNotNull((Object)contentHandler), !noRecurse, !skipBinary));
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ToXmlContentHandler handler = new ToXmlContentHandler((OutputStream)Preconditions.checkNotNull((Object)out));
            this.export((String)Preconditions.checkNotNull((Object)absPath), (Exporter)new DocumentViewExporter((Session)this, (ContentHandler)handler, !noRecurse, !skipBinary));
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing document view XML", (Throwable)e);
        }
    }

    public void addLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().addLockToken((String)Preconditions.checkNotNull((Object)lt));
        }
        catch (RepositoryException e) {
            log.warn("Unable to add lock token " + lt + " to session", (Throwable)e);
        }
    }

    @Nonnull
    public String[] getLockTokens() {
        try {
            return this.getWorkspace().getLockManager().getLockTokens();
        }
        catch (RepositoryException e) {
            log.warn("Unable to retrieve lock tokens from session", (Throwable)e);
            return new String[0];
        }
    }

    public void removeLockToken(String lt) {
        try {
            this.getWorkspace().getLockManager().removeLockToken((String)Preconditions.checkNotNull((Object)lt));
        }
        catch (RepositoryException e) {
            log.warn("Unable to remove lock token " + lt + " from session", (Throwable)e);
        }
    }

    public boolean hasPermission(String absPath, final String actions) throws RepositoryException {
        final String oakPath = this.getOakPathOrThrow((String)Preconditions.checkNotNull((Object)absPath));
        Preconditions.checkNotNull((Object)actions);
        return this.perform(new ReadOperation<Boolean>("hasPermission"){

            @Override
            public Boolean perform() throws RepositoryException {
                return SessionImpl.this.sessionContext.getAccessManager().hasPermissions(oakPath, actions);
            }
        });
    }

    public void checkPermission(String absPath, String actions) throws RepositoryException {
        if (!this.hasPermission((String)Preconditions.checkNotNull((Object)absPath), (String)Preconditions.checkNotNull((Object)actions))) {
            throw new AccessControlException("Access denied.");
        }
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        Preconditions.checkNotNull((Object)methodName);
        Preconditions.checkNotNull((Object)target);
        this.sd.checkAlive();
        if (target instanceof ItemImpl) {
            Node parent;
            Object dlg = ((ItemImpl)target).dlg;
            if (((ItemDelegate)dlg).isProtected()) {
                return false;
            }
            boolean isNode = ((ItemImpl)target).isNode();
            Node node = parent = isNode ? (Node)target : ((ItemImpl)target).getParent();
            if (!parent.isCheckedOut()) {
                return false;
            }
            if (parent.isLocked()) {
                return false;
            }
            AccessManager accessMgr = this.sessionContext.getAccessManager();
            long permission = 0L;
            if (isNode) {
                Tree tree = ((NodeDelegate)dlg).getTree();
                if ("addNode".equals(methodName)) {
                    if (arguments != null && arguments.length > 0) {
                        String path = PathUtils.concat((String)tree.getPath(), (String)this.sessionContext.getOakName(arguments[0].toString()));
                        return accessMgr.hasPermissions(path, "add_node");
                    }
                } else if ("setPrimaryType".equals(methodName) || "addMixin".equals(methodName) || "removeMixin".equals(methodName)) {
                    permission = 512L;
                } else if ("orderBefore".equals(methodName)) {
                    if (tree.isRoot()) {
                        return false;
                    }
                    permission = 16384L;
                    tree = tree.getParent();
                } else if ("setProperty".equals(methodName)) {
                    permission = 4L;
                } else if ("remove".equals(methodName)) {
                    permission = 64L;
                }
                return accessMgr.hasPermissions(tree, null, permission);
            }
            if ("setValue".equals(methodName)) {
                permission = 8L;
            } else if ("remove".equals(methodName)) {
                permission = 16L;
            }
            Tree tree = ((ItemDelegate)dlg).getParent().getTree();
            return accessMgr.hasPermissions(tree, ((PropertyDelegate)dlg).getPropertyState(), permission);
        }
        return true;
    }

    @Nonnull
    public AccessControlManager getAccessControlManager() throws RepositoryException {
        return this.sessionContext.getAccessControlManager();
    }

    @Nonnull
    public RetentionManager getRetentionManager() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("Retention Management is not supported.");
    }

    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        this.sessionContext.getNamespaces().setNamespacePrefix((String)Preconditions.checkNotNull((Object)prefix), (String)Preconditions.checkNotNull((Object)uri));
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespaceURI((String)Preconditions.checkNotNull((Object)prefix));
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        return this.sessionContext.getNamespaces().getNamespacePrefix((String)Preconditions.checkNotNull((Object)uri));
    }

    @Nonnull
    public PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.sessionContext.getPrincipalManager();
    }

    @Nonnull
    public UserManager getUserManager() throws RepositoryException {
        return this.sessionContext.getUserManager();
    }

    public String toString() {
        return this.sd.getContentSession().toString();
    }

    private abstract class WriteOperation<T>
    extends SessionOperation<T> {
        protected WriteOperation(String name) {
            super(name, true);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            SessionImpl.this.sd.checkAlive();
        }
    }

    private abstract class ReadOperation<T>
    extends SessionOperation<T> {
        protected ReadOperation(String name) {
            super(name);
        }

        @Override
        public void checkPreconditions() throws RepositoryException {
            SessionImpl.this.sd.checkAlive();
        }
    }
}

