/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RefreshStrategy {
    public boolean needsRefresh(long var1);

    public void refreshed();

    public static class LogOnce
    extends Timed {
        private static final Logger log = LoggerFactory.getLogger(RefreshStrategy.class);
        private final Exception initStackTrace = new Exception("The session was created here:");
        private boolean warnIfIdle = true;

        public LogOnce(long interval) {
            super(interval);
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            if (super.needsRefresh(secondsSinceLastAccess) && this.warnIfIdle) {
                log.warn("This session has been idle for " + TimeUnit.MINUTES.convert(secondsSinceLastAccess, TimeUnit.SECONDS) + " minutes and might be out of date. " + "Consider using a fresh session or explicitly refresh the session.", (Throwable)this.initStackTrace);
            }
            return false;
        }

        @Override
        public void refreshed() {
            this.warnIfIdle = false;
        }

        @Override
        public String toString() {
            return "Never refresh but log warning after more than " + this.interval + " seconds of inactivity";
        }
    }

    public static class Timed
    implements RefreshStrategy {
        protected final long interval;

        public Timed(long interval) {
            this.interval = interval;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return secondsSinceLastAccess > this.interval;
        }

        @Override
        public void refreshed() {
        }

        public String toString() {
            return "Refresh every " + this.interval + " seconds";
        }
    }

    public static class Composite
    implements RefreshStrategy {
        private final RefreshStrategy[] refreshStrategies;

        public static RefreshStrategy create(RefreshStrategy ... refreshStrategies) {
            ArrayList strategies = Lists.newArrayList();
            for (RefreshStrategy strategy : refreshStrategies) {
                if (strategy instanceof Composite) {
                    strategies.addAll(Arrays.asList(((Composite)strategy).refreshStrategies));
                    continue;
                }
                strategies.add(strategy);
            }
            return new Composite(strategies.toArray(new RefreshStrategy[strategies.size()]));
        }

        private Composite(RefreshStrategy ... refreshStrategies) {
            this.refreshStrategies = refreshStrategies;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            for (RefreshStrategy r : this.refreshStrategies) {
                if (!r.needsRefresh(secondsSinceLastAccess)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void refreshed() {
            for (RefreshStrategy refreshStrategy : this.refreshStrategies) {
                refreshStrategy.refreshed();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (RefreshStrategy strategy : this.refreshStrategies) {
                sb.append(sep).append(strategy.toString());
                sep = ", ";
            }
            return sb.toString();
        }
    }
}

