/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.http;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.http.MediaRange;
import org.apache.jackrabbit.oak.http.Representation;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class AcceptHeader {
    private static final MediaTypeRegistry registry = MediaTypeRegistry.getDefaultRegistry();
    private final List<MediaRange> ranges = new ArrayList<MediaRange>();

    public AcceptHeader(String accept) {
        if (accept == null) {
            this.ranges.add(new MediaRange(MediaType.parse((String)"*/*"), 1.0));
        } else {
            for (String part : accept.split("(\\s*,)+\\s*")) {
                MediaRange range = MediaRange.parse(part, registry);
                if (range == null) continue;
                this.ranges.add(range);
            }
        }
    }

    public Representation resolve(Representation ... representations) {
        Preconditions.checkArgument((representations != null && representations.length > 0 ? 1 : 0) != 0);
        int maxIndex = 0;
        double maxQ = 0.0;
        for (int i = 0; i < representations.length; ++i) {
            double q = 0.0;
            MediaType type = registry.normalize(representations[i].getType());
            for (MediaRange range : this.ranges) {
                q = Math.max(q, range.match(type, registry));
            }
            if (!(q > maxQ)) continue;
            maxIndex = i;
            maxQ = q;
        }
        return representations[maxIndex];
    }
}

