/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.split;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlobIdSet {
    private static final Logger log = LoggerFactory.getLogger(BlobIdSet.class);
    private final File store;
    private final BloomFilter<CharSequence> bloomFilter;
    private final Cache<String, Boolean> cache;

    BlobIdSet(String repositoryDir, String filename) {
        this.store = new File(new File(repositoryDir), filename);
        this.bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.UTF_8), (int)9000000);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        this.fillBloomFilter();
    }

    synchronized boolean contains(String blobId) throws IOException {
        if (!this.bloomFilter.apply((Object)blobId)) {
            return false;
        }
        Boolean cached = (Boolean)this.cache.getIfPresent((Object)blobId);
        if (cached != null) {
            return cached;
        }
        if (this.isPresentInStore(blobId)) {
            this.cache.put((Object)blobId, (Object)Boolean.TRUE);
            this.bloomFilter.put((Object)blobId);
            return true;
        }
        this.cache.put((Object)blobId, (Object)Boolean.FALSE);
        return false;
    }

    synchronized void add(String blobId) throws IOException {
        this.addToStore(blobId);
        this.bloomFilter.put((Object)blobId);
        this.cache.put((Object)blobId, (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPresentInStore(String blobId) throws FileNotFoundException, IOException {
        if (!this.store.exists()) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.store));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.equals(blobId)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            reader.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToStore(String blobId) throws IOException {
        FileWriter writer = new FileWriter(this.store.getPath(), true);
        try {
            writer.append(blobId).append('\n');
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillBloomFilter() {
        if (!this.store.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.store));
            while ((line = reader.readLine()) != null) {
                this.bloomFilter.put((Object)line);
            }
        }
        catch (IOException e) {
            try {
                log.error("Can't fill bloom filter", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

