/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.stats;

import com.google.common.io.CountingInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;

public final class StatsCollectingStreams {
    public static InputStream wrap(final BlobStatsCollector collector, final String blobId, InputStream in) {
        final CountingInputStream cin = new CountingInputStream(in);
        return new FilterInputStream((InputStream)cin){
            final long startTime;
            {
                super(x0);
                this.startTime = System.nanoTime();
            }

            @Override
            public void close() throws IOException {
                super.close();
                collector.downloaded(blobId, System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS, cin.getCount());
                collector.downloadCompleted(blobId);
            }
        };
    }
}

