/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob.split;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.split.BlobIdSet;
import org.apache.jackrabbit.oak.spi.blob.split.SplitBlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSplitBlobStore
implements SplitBlobStore {
    private static final Logger log = LoggerFactory.getLogger(BlobIdSet.class);
    private static final String OLD_BLOBSTORE_PREFIX = "o_";
    private static final String NEW_BLOBSTORE_PREFIX = "n_";
    private final BlobStore oldBlobStore;
    private final BlobStore newBlobStore;
    private final BlobIdSet migratedBlobs;

    public DefaultSplitBlobStore(String repositoryDir, BlobStore oldBlobStore, BlobStore newBlobStore) {
        this.oldBlobStore = oldBlobStore;
        this.newBlobStore = newBlobStore;
        this.migratedBlobs = new BlobIdSet(repositoryDir, "migrated_blobs.txt");
    }

    @Override
    public boolean isMigrated(String blobId) throws IOException {
        return this.migratedBlobs.contains(blobId);
    }

    @Override
    public String writeBlob(InputStream in) throws IOException {
        String blobId = this.newBlobStore.writeBlob(in);
        this.migratedBlobs.add(blobId);
        return blobId;
    }

    @Override
    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) throws IOException {
        return this.chooseBlobStoreByBlobId(blobId).readBlob(blobId, pos, buff, off, length);
    }

    @Override
    public long getBlobLength(String blobId) throws IOException {
        return this.chooseBlobStoreByBlobId(blobId).getBlobLength(blobId);
    }

    @Override
    public InputStream getInputStream(String blobId) throws IOException {
        return this.chooseBlobStoreByBlobId(blobId).getInputStream(blobId);
    }

    @Override
    public String getBlobId(String reference) {
        if (reference.startsWith(NEW_BLOBSTORE_PREFIX)) {
            return this.newBlobStore.getBlobId(reference.substring(NEW_BLOBSTORE_PREFIX.length()));
        }
        if (reference.startsWith(OLD_BLOBSTORE_PREFIX)) {
            return this.oldBlobStore.getBlobId(reference.substring(OLD_BLOBSTORE_PREFIX.length()));
        }
        log.error("Invalid reference: {}", (Object)reference);
        return null;
    }

    @Override
    public String getReference(String blobId) {
        try {
            if (this.isMigrated(blobId)) {
                return NEW_BLOBSTORE_PREFIX + this.newBlobStore.getReference(blobId);
            }
            return OLD_BLOBSTORE_PREFIX + this.oldBlobStore.getReference(blobId);
        }
        catch (IOException e) {
            log.error("Can't get reference", (Throwable)e);
            return null;
        }
    }

    private BlobStore chooseBlobStoreByBlobId(String blobId) throws IOException {
        if (this.isMigrated(blobId) || this.oldBlobStore == null) {
            return this.newBlobStore;
        }
        return this.oldBlobStore;
    }

    public String toString() {
        return String.format("SplitBlobStore[old={}, new={}]", this.oldBlobStore, this.newBlobStore);
    }
}

