/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SyncHandlerMappingTracker;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncConfigTracker
extends ServiceTracker {
    private static final Logger log = LoggerFactory.getLogger(SyncConfigTracker.class);
    private final SyncHandlerMappingTracker mappingTracker;
    private Set<ServiceReference> enablingRefs = new HashSet<ServiceReference>();
    private boolean isEnabled = false;

    SyncConfigTracker(@NotNull BundleContext context, @NotNull SyncHandlerMappingTracker mappingTracker) {
        super(context, SyncHandler.class.getName(), null);
        this.mappingTracker = mappingTracker;
    }

    public Object addingService(ServiceReference reference) {
        if (SyncConfigTracker.hasDynamicMembership(reference)) {
            this.enablingRefs.add(reference);
            this.isEnabled = true;
        }
        return super.addingService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        if (SyncConfigTracker.hasDynamicMembership(reference)) {
            this.enablingRefs.add(reference);
            this.isEnabled = true;
        } else {
            this.enablingRefs.remove(reference);
            this.isEnabled = !this.enablingRefs.isEmpty();
        }
        super.modifiedService(reference, service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.enablingRefs.remove(reference);
        this.isEnabled = !this.enablingRefs.isEmpty();
        super.removedService(reference, service);
    }

    private static boolean hasDynamicMembership(@NotNull ServiceReference reference) {
        return PropertiesUtil.toBoolean((Object)reference.getProperty("user.dynamicMembership"), (boolean)false);
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    @NotNull
    Map<String, String[]> getAutoMembership() {
        HashMap<String, String[]> autoMembership = new HashMap<String, String[]>();
        for (ServiceReference ref : this.enablingRefs) {
            String syncHandlerName = PropertiesUtil.toString((Object)ref.getProperty("handler.name"), (String)"default");
            Object[] userAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("user.autoMembership"), (String[])new String[0]);
            Object[] groupAuthMembership = PropertiesUtil.toStringArray((Object)ref.getProperty("group.autoMembership"), (String[])new String[0]);
            Object[] membership = (String[])ObjectArrays.concat((Object[])userAuthMembership, (Object[])groupAuthMembership, String.class);
            for (String idpName : this.mappingTracker.getIdpNames(syncHandlerName)) {
                Object[] previous = autoMembership.put(idpName, (String[])membership);
                if (previous == null) continue;
                String msg = Arrays.equals(previous, membership) ? "Duplicate" : "Colliding";
                String prev = Arrays.toString(previous);
                String mbrs = Arrays.toString(membership);
                log.debug("{} auto-membership configuration for IDP '{}'; replacing previous values {} by {} defined by SyncHandler '{}'", new Object[]{msg, idpName, prev, mbrs, syncHandlerName});
            }
        }
        return autoMembership;
    }
}

