/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl;

import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.DebugTimer;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.ImpersonationCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.SimpleCredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProviderManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncHandler;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncManager;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncedIdentity;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(ExternalLoginModule.class);
    private static final int MAX_SYNC_ATTEMPTS = 50;
    public static final String PARAM_IDP_NAME = "idp.name";
    public static final String PARAM_SYNC_HANDLER_NAME = "sync.handlerName";
    private ExternalIdentityProviderManager idpManager;
    private SyncManager syncManager;
    private CredentialsSupport credentialsSupport = SimpleCredentialsSupport.getInstance();
    private ConfigurationParameters osgiConfig;
    private ExternalIdentityProvider idp;
    private SyncHandler syncHandler;
    private ExternalUser externalUser;
    private Credentials credentials;
    private Set<? extends Principal> principals;
    private AuthInfo authInfo;

    public ExternalLoginModule() {
    }

    public ExternalLoginModule(ConfigurationParameters osgiConfig) {
        this.osgiConfig = osgiConfig;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> opts) {
        Whiteboard whiteboard;
        super.initialize(subject, callbackHandler, sharedState, opts);
        if (this.osgiConfig != null) {
            this.options = ConfigurationParameters.of((ConfigurationParameters[])new ConfigurationParameters[]{this.osgiConfig, this.options});
        }
        if ((whiteboard = this.getWhiteboard()) == null) {
            log.error("External login module needs whiteboard. Will not be used for login.");
            return;
        }
        String idpName = (String)this.options.getConfigValue(PARAM_IDP_NAME, (Object)"");
        if (idpName.isEmpty()) {
            log.error("External login module needs IPD name. Will not be used for login.");
        } else {
            if (this.idpManager == null) {
                this.idpManager = (ExternalIdentityProviderManager)WhiteboardUtils.getService((Whiteboard)whiteboard, ExternalIdentityProviderManager.class);
            }
            if (this.idpManager == null) {
                log.error("External login module needs IDPManager. Will not be used for login.");
            } else {
                this.idp = this.idpManager.getProvider(idpName);
                if (this.idp == null) {
                    log.error("No IDP found with name {}. Will not be used for login.", (Object)idpName);
                }
            }
        }
        String syncHandlerName = (String)this.options.getConfigValue(PARAM_SYNC_HANDLER_NAME, (Object)"");
        if (syncHandlerName.isEmpty()) {
            log.error("External login module needs SyncHandler name. Will not be used for login.");
        } else {
            if (this.syncManager == null) {
                this.syncManager = (SyncManager)WhiteboardUtils.getService((Whiteboard)whiteboard, SyncManager.class);
            }
            if (this.syncManager == null) {
                log.error("External login module needs SyncManager. Will not be used for login.");
            } else {
                this.syncHandler = this.syncManager.getSyncHandler(syncHandlerName);
                if (this.syncHandler == null) {
                    log.error("No SyncHandler found with name {}. Will not be used for login.", (Object)syncHandlerName);
                }
            }
        }
        if (this.idp instanceof CredentialsSupport) {
            this.credentialsSupport = (CredentialsSupport)this.idp;
        } else {
            log.debug("No 'SupportedCredentials' configured. Using default implementation supporting 'SimpleCredentials'.");
        }
    }

    public boolean login() throws LoginException {
        if (this.idp == null || this.syncHandler == null) {
            return false;
        }
        Credentials creds = this.getCredentials();
        PreAuthenticatedLogin preAuthLogin = this.getSharedPreAuthLogin();
        String userId = this.getUserId(preAuthLogin, creds);
        if (userId == null && creds == null) {
            log.debug("No credentials|userId found for external login module. ignoring.");
            return false;
        }
        String logId = userId != null ? userId : creds;
        try {
            SyncedIdentity sId = this.getSyncedIdentity(userId);
            if (this.ignore(sId, preAuthLogin)) {
                return false;
            }
            this.externalUser = preAuthLogin != null ? this.idp.getUser(preAuthLogin.getUserId()) : this.idp.authenticate(creds);
            if (this.externalUser != null) {
                log.debug("IDP {} returned valid user {}", (Object)this.idp.getName(), (Object)this.externalUser);
                if (creds != null) {
                    this.sharedState.put("org.apache.jackrabbit.credentials", creds);
                }
                this.sharedState.put("javax.security.auth.login.name", this.externalUser.getId());
                this.syncUser(this.externalUser);
                this.credentials = creds;
                return true;
            }
            ExternalLoginModule.debug("IDP {} returned null for {}", this.idp.getName(), logId.toString());
            if (sId != null) {
                log.debug("local user exists for '{}'. re-validating.", (Object)sId.getId());
                this.validateUser(sId.getId());
            }
            return false;
        }
        catch (ExternalIdentityException e) {
            log.error("Error while authenticating '{}' with {}", new Object[]{logId, this.idp.getName(), e});
            this.onError();
            return false;
        }
        catch (LoginException e) {
            log.debug("IDP {} throws login exception for '{}': {}", new Object[]{this.idp.getName(), logId, e.getMessage()});
            throw e;
        }
        catch (RepositoryException | SyncException e) {
            this.onError();
            log.error("SyncHandler {} throws sync exception for '{}'", new Object[]{this.syncHandler.getName(), logId, e});
            LoginException le = new LoginException("Error while syncing user.");
            le.initCause(e);
            throw le;
        }
    }

    public boolean commit() {
        if (this.externalUser == null) {
            this.clearState();
            return false;
        }
        this.principals = this.getPrincipals(this.externalUser.getId());
        this.authInfo = this.createAuthInfo(this.externalUser.getId(), this.principals);
        if (!this.subject.isReadOnly()) {
            this.subject.getPrincipals().addAll(this.principals);
            if (this.credentials != null) {
                this.subject.getPublicCredentials().add(this.credentials);
            }
            ExternalLoginModule.setAuthInfo((AuthInfo)this.authInfo, (Subject)this.subject);
        } else {
            log.debug("Could not add information to read only subject.");
        }
        this.closeSystemSession();
        return true;
    }

    public boolean abort() {
        this.clearState();
        return true;
    }

    public boolean logout() throws LoginException {
        Set creds = Stream.of(this.credentials, this.authInfo).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.logout(creds.isEmpty() ? null : creds, this.principals);
    }

    @Nullable
    private String getUserId(@Nullable PreAuthenticatedLogin preAuthLogin, @Nullable Credentials credentials) {
        if (preAuthLogin != null) {
            return preAuthLogin.getUserId();
        }
        if (credentials != null) {
            return this.credentialsSupport.getUserId(credentials);
        }
        return null;
    }

    @Nullable
    private SyncedIdentity getSyncedIdentity(@Nullable String userId) throws RepositoryException {
        UserManager userMgr = this.getUserManager();
        if (userId != null && userMgr != null) {
            return this.syncHandler.findIdentity(userMgr, userId);
        }
        return null;
    }

    private boolean ignore(@Nullable SyncedIdentity syncedIdentity, @Nullable PreAuthenticatedLogin preAuthLogin) {
        if (syncedIdentity != null) {
            ExternalIdentityRef externalIdRef = syncedIdentity.getExternalIdRef();
            if (externalIdRef == null) {
                ExternalLoginModule.debug("ignoring local user: {}", syncedIdentity.getId());
                return true;
            }
            if (!this.idp.getName().equals(externalIdRef.getProviderName())) {
                ExternalLoginModule.debug("ignoring foreign identity: {} (idp={})", externalIdRef.getString(), this.idp.getName());
                return true;
            }
            if (preAuthLogin != null && !this.syncHandler.requiresSync(syncedIdentity)) {
                ExternalLoginModule.debug("pre-authenticated external user {} does not require syncing.", syncedIdentity.toString());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUser(@NotNull ExternalUser user) throws SyncException {
        Root root = this.getRootOrThrow();
        UserManager userManager = this.getUsermanagerOrThrow();
        int numAttempt = 0;
        while (numAttempt++ < 50) {
            try (SyncContext context = this.syncHandler.createContext(this.idp, userManager, (ValueFactory)new ValueFactoryImpl(root, NamePathMapper.DEFAULT));){
                DebugTimer timer = new DebugTimer();
                SyncResult syncResult = context.sync(user);
                timer.mark("sync");
                if (root.hasPendingChanges()) {
                    root.commit();
                    timer.mark("commit");
                }
                ExternalLoginModule.debug("syncUser({}) {}, status: {}", user.getId(), timer.getString(), syncResult.getStatus().toString());
                return;
            }
        }
        throw new SyncException("User synchronization failed during commit after 50 attempts");
    }

    private void validateUser(@NotNull String id) throws SyncException {
        Root root = this.getRootOrThrow();
        UserManager userManager = this.getUsermanagerOrThrow();
        try (SyncContext context = this.syncHandler.createContext(this.idp, userManager, (ValueFactory)new ValueFactoryImpl(root, NamePathMapper.DEFAULT));){
            DebugTimer timer = new DebugTimer();
            context = this.syncHandler.createContext(this.idp, userManager, (ValueFactory)new ValueFactoryImpl(root, NamePathMapper.DEFAULT));
            context.sync(id);
            timer.mark("sync");
            root.commit();
            timer.mark("commit");
            ExternalLoginModule.debug("validateUser({}) {}", id, timer.getString());
        }
    }

    @NotNull
    private AuthInfo createAuthInfo(@NotNull String userId, @NotNull Set<? extends Principal> principals) {
        Credentials creds = this.credentials instanceof ImpersonationCredentials ? ((ImpersonationCredentials)this.credentials).getBaseCredentials() : this.credentials;
        HashMap attributes = new HashMap();
        Object shared = this.sharedState.get("javax.security.auth.login.attributes");
        if (shared instanceof Map) {
            ((Map)shared).forEach((key, value) -> attributes.put(key.toString(), value));
        }
        if (creds != null) {
            attributes.putAll(this.credentialsSupport.getAttributes(creds));
        }
        return new AuthInfoImpl(userId, attributes, Iterables.concat(principals, this.subject.getPrincipals()));
    }

    @NotNull
    private Root getRootOrThrow() throws SyncException {
        Root root = this.getRoot();
        if (root == null) {
            throw new SyncException("Cannot synchronize user. root == null");
        }
        return root;
    }

    @NotNull
    private UserManager getUsermanagerOrThrow() throws SyncException {
        UserManager userManager = this.getUserManager();
        if (userManager == null) {
            throw new SyncException("Cannot synchronize user. userManager == null");
        }
        return userManager;
    }

    private static void debug(@NotNull String msg, String ... args) {
        if (log.isDebugEnabled()) {
            log.debug(msg, (Object[])args);
        }
    }

    protected void clearState() {
        super.clearState();
        this.externalUser = null;
        this.credentials = null;
        this.authInfo = null;
        this.principals = null;
    }

    @NotNull
    protected Set<Class> getSupportedCredentials() {
        return this.credentialsSupport.getCredentialClasses();
    }

    public void setSyncManager(@NotNull SyncManager syncManager) {
        this.syncManager = syncManager;
    }

    public void setIdpManager(@NotNull ExternalIdentityProviderManager idpManager) {
        this.idpManager = idpManager;
    }
}

