/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public class ValidationMessagePrinter
implements Closeable {
    private int noOfEmittedValidationMessagesWithLevelWarn = 0;
    private int noOfEmittedValidationMessagesWithLevelError = 0;
    @Nullable
    private final Path csvReportFile;
    @Nullable
    private final CSVPrinter csvPrinter;
    private final Log log;

    public ValidationMessagePrinter(@NotNull Log log, @Nullable Path csvReportFile) throws IOException {
        this.log = log;
        this.csvReportFile = csvReportFile;
        if (csvReportFile != null) {
            this.csvPrinter = new CSVPrinter((Appendable)Files.newBufferedWriter(csvReportFile, StandardCharsets.UTF_8, new OpenOption[0]), CSVFormat.EXCEL);
            this.csvPrinter.printRecord(new Object[]{"Severity", "Validator ID", "Message", "File", "Line:Column", "Node Path"});
        } else {
            this.csvPrinter = null;
        }
    }

    public void printMessages(Collection<ValidationViolation> violations, BuildContext buildContext, Path baseDirectory) throws IOException {
        for (ValidationViolation violation : violations) {
            int buildContextSeverity;
            switch (violation.getSeverity()) {
                case ERROR: {
                    this.log.error((CharSequence)ValidationMessagePrinter.getDetailMessage(violation, baseDirectory));
                    buildContextSeverity = 2;
                    ++this.noOfEmittedValidationMessagesWithLevelError;
                    break;
                }
                case WARN: {
                    this.log.warn((CharSequence)ValidationMessagePrinter.getDetailMessage(violation, baseDirectory));
                    ++this.noOfEmittedValidationMessagesWithLevelWarn;
                    buildContextSeverity = 1;
                    break;
                }
                case INFO: {
                    this.log.info((CharSequence)ValidationMessagePrinter.getDetailMessage(violation, baseDirectory));
                    buildContextSeverity = -1;
                    break;
                }
                default: {
                    this.log.debug((CharSequence)ValidationMessagePrinter.getDetailMessage(violation, baseDirectory));
                    buildContextSeverity = -1;
                }
            }
            if (violation.getThrowable() != null) {
                this.log.debug(violation.getThrowable());
            }
            if (buildContextSeverity <= 0) continue;
            if (!(buildContext instanceof DefaultBuildContext)) {
                Path file = violation.getAbsoluteFilePath() != null ? violation.getAbsoluteFilePath() : baseDirectory;
                buildContext.addMessage(file.toFile(), violation.getLine(), violation.getColumn(), ValidationMessagePrinter.getMessage(violation), buildContextSeverity, violation.getThrowable());
            }
            if (buildContext.isIncremental() || this.csvPrinter == null) continue;
            this.printToCsvFile(violation);
        }
    }

    private static String getMessage(ValidationViolation violation) {
        StringBuilder message = new StringBuilder();
        if (violation.getValidatorId() != null) {
            message.append(violation.getValidatorId()).append(": ");
        }
        message.append(violation.getMessage());
        return message.toString();
    }

    public void printUsedValidators(Log log, ValidationExecutor executor, ValidationContext context, boolean printUnusedValidators) {
        Map unusedValidatorsById;
        String packageType = context.getProperties().getPackageType() != null ? context.getProperties().getPackageType().toString() : "unknown";
        log.info((CharSequence)("Using " + executor.getAllValidatorsById().entrySet().size() + " validators for package of type " + packageType + ": " + ValidationMessagePrinter.getValidatorNames(executor, ", ")));
        if (printUnusedValidators && !(unusedValidatorsById = executor.getUnusedValidatorsById()).isEmpty()) {
            log.warn((CharSequence)("There are unused validators among those which are not executed: " + StringUtils.join(unusedValidatorsById.keySet(), (String)".")));
        }
    }

    private static String getDetailMessage(ValidationViolation violation, Path baseDirectory) {
        MessageBuilder builder = MessageUtils.buffer();
        builder.strong((Object)"ValidationViolation: ");
        builder.a((CharSequence)violation.getMessage());
        if (violation.getFilePath() != null) {
            builder.a((CharSequence)" @ ").strong((Object)baseDirectory.relativize(violation.getAbsoluteFilePath()));
        }
        if (violation.getLine() > 0) {
            builder.strong((Object)", line ").strong((Object)violation.getLine());
        }
        if (violation.getColumn() > 0) {
            builder.strong((Object)", column ").strong((Object)violation.getColumn());
        }
        if (violation.getValidatorId() != null) {
            builder.a((CharSequence)", validator: ").strong((Object)violation.getValidatorId());
        }
        if (violation.getNodePath() != null) {
            builder.a((CharSequence)", JCR node path: ").strong((Object)violation.getNodePath());
        }
        if (violation.getThrowable() != null) {
            builder.a((CharSequence)", Throwable: ").strong((Object)violation.getThrowable().getMessage());
        }
        return builder.toString();
    }

    private static String getValidatorNames(ValidationExecutor executor, String separator) {
        StringBuilder validatorNames = new StringBuilder();
        boolean isFirstItem = true;
        for (Map.Entry validatorById : executor.getAllValidatorsById().entrySet()) {
            if (!isFirstItem) {
                validatorNames.append(separator);
            } else {
                isFirstItem = false;
            }
            validatorNames.append((String)validatorById.getKey()).append(" (").append(((Validator)validatorById.getValue()).getClass().getName()).append(")");
        }
        return validatorNames.toString();
    }

    public void clearPreviousValidationMessages(BuildContext context, File file) {
        context.removeMessages(file);
    }

    public void failBuildInCaseOfViolations(boolean failForWarning) throws MojoFailureException {
        if (failForWarning && (this.noOfEmittedValidationMessagesWithLevelWarn > 0 || this.noOfEmittedValidationMessagesWithLevelError > 0)) {
            throw new MojoFailureException("Found " + this.noOfEmittedValidationMessagesWithLevelWarn + this.noOfEmittedValidationMessagesWithLevelError + " violation(s) (either ERROR or WARN). Check above warnings/errors for details");
        }
        if (this.noOfEmittedValidationMessagesWithLevelError > 0) {
            throw new MojoFailureException("Found " + this.noOfEmittedValidationMessagesWithLevelError + " violation(s) (with severity=ERROR). Check above errors for details");
        }
    }

    private void printToCsvFile(ValidationViolation violation) throws IOException {
        this.csvPrinter.printRecord(new Object[]{violation.getSeverity(), violation.getValidatorId(), violation.getMessage(), violation.getAbsoluteFilePath(), MessageFormat.format("{0}:{1}", violation.getLine(), violation.getColumn()), violation.getNodePath()});
    }

    @Override
    public void close() throws IOException {
        if (this.csvPrinter != null) {
            this.log.info((CharSequence)("CSV report written to '" + this.csvReportFile + "'"));
            this.csvPrinter.close();
        }
    }
}

