/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.filevault.maven.packaging.mojo.AbstractSourceAndMetadataPackageMojo;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.compact.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.StandaloneManagerProvider;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.CndUtil;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.URLFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;

@Mojo(name="generate-cnd", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateCndMojo
extends AbstractSourceAndMetadataPackageMojo {
    @Parameter(property="vault.inputCndUrls")
    List<String> additionalInputCndUrls = new LinkedList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Retrieving used node types and namespaces...");
        try {
            StandaloneManagerProvider managerProvider = new StandaloneManagerProvider();
            URLFactory.processUrlStreams((List)CndUtil.resolveJarUrls(this.additionalInputCndUrls), t -> {
                try {
                    managerProvider.registerNodeTypes(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (RepositoryException | ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            });
            File cndOutputFile = new File(this.getGeneratedVaultDir(true), "nodetypes.cnd");
            File jcrSourceDirectory = this.getJcrSourceDirectory();
            if (jcrSourceDirectory == null) {
                this.getLog().warn((CharSequence)"None of the configured jcrRootSourceDirectory directories exists, skipping generating the CND!");
            } else {
                int numWrittenNodeTypes = this.generateCnd(managerProvider, cndOutputFile.toPath(), this.getJcrSourceDirectory().toPath());
                this.getLog().info((CharSequence)("Written " + numWrittenNodeTypes + " node types to CND file " + this.getProjectRelativeFilePath(cndOutputFile)));
            }
        }
        catch (IOException | IllegalStateException | RepositoryException | ParseException e) {
            throw new MojoExecutionException("Error while writing CND: " + e.toString(), (Exception)e);
        }
    }

    public int generateCnd(StandaloneManagerProvider managerProvider, Path cndOutputFile, Path jcrSourceDirectory) throws IOException, RepositoryException, ParseException {
        Set<String> nodeTypes;
        DocViewParser docViewParser = new DocViewParser(managerProvider.getNamespaceResolver());
        try {
            nodeTypes = this.collectNodeTypes(jcrSourceDirectory, docViewParser);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        this.getLog().info((CharSequence)("Found " + nodeTypes.size() + " unique node types"));
        Collection<QNodeTypeDefinition> ntDefinitons = this.resolveNodeTypes(nodeTypes, managerProvider.getNameResolver(), managerProvider.getNodeTypeDefinitionProvider());
        Files.createDirectories(cndOutputFile.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(cndOutputFile, StandardCharsets.US_ASCII, new OpenOption[0]);){
            int n = this.writeCnd(ntDefinitons, managerProvider.getNodeTypeDefinitionProvider(), managerProvider.getNamespaceResolver(), writer);
            return n;
        }
    }

    private Set<String> collectNodeTypes(Path jcrRootPath, DocViewParser docViewParser) throws IOException {
        HashSet<String> nodeTypes = new HashSet<String>();
        nodeTypes.add("nt:file");
        nodeTypes.add("nt:folder");
        NodeTypeCollectorHandler nodeTypeCollectorHandler = new NodeTypeCollectorHandler(nodeTypes);
        try (Stream<Path> filePaths = Files.find(jcrRootPath, 50, (path, attributes) -> !attributes.isDirectory() && path.getFileName().toString().endsWith(".xml"), new FileVisitOption[0]);){
            filePaths.forEach(p -> {
                nodeTypeCollectorHandler.setFile((Path)p);
                this.getNodeTypes(jcrRootPath, (Path)p, docViewParser, nodeTypeCollectorHandler);
            });
        }
        return nodeTypes;
    }

    private void getNodeTypes(Path jcrRootPath, Path docViewFile, DocViewParser docViewParser, NodeTypeCollectorHandler nodeTypeCollectorHandler) {
        try (InputStream is = Files.newInputStream(docViewFile, new OpenOption[0]);
             BufferedInputStream bufferedIs = new BufferedInputStream(is);){
            String documentViewXmlRootNodePath = DocViewParser.getDocumentViewXmlRootNodePath((InputStream)bufferedIs, (Path)jcrRootPath.relativize(docViewFile));
            if (documentViewXmlRootNodePath == null) {
                return;
            }
            InputSource inputSource = new InputSource(bufferedIs);
            docViewParser.parse(documentViewXmlRootNodePath, inputSource, (DocViewParserHandler)nodeTypeCollectorHandler);
        }
        catch (IOException | DocViewParser.XmlParseException e) {
            this.getLog().warn((CharSequence)("Could not parse " + docViewFile + ". Ignore for node type definition generation!"), e);
        }
    }

    private Collection<QNodeTypeDefinition> resolveNodeTypes(Set<String> nodeTypeNames, NameResolver nameResolver, NodeTypeDefinitionProvider ntDefinitionProvider) throws IOException, RepositoryException, ParseException {
        return GenerateCndMojo.resolveNodeTypesFromNames(nodeTypeNames.stream().map(name -> {
            try {
                return nameResolver.getQName(name);
            }
            catch (NamespaceException | IllegalNameException e) {
                throw new IllegalStateException("Cannot get expanded name for type " + name, e);
            }
        }).collect(Collectors.toSet()), ntDefinitionProvider);
    }

    static Collection<QNodeTypeDefinition> resolveNodeTypesFromNames(Set<Name> nodeTypeNames, NodeTypeDefinitionProvider ntDefinitionProvider) throws IOException, RepositoryException, ParseException {
        return nodeTypeNames.stream().map(name -> {
            try {
                return ntDefinitionProvider.getNodeTypeDefinition(name);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("RepositoryException ", e);
            }
        }).collect(Collectors.toList());
    }

    private int writeCnd(Collection<? extends QNodeTypeDefinition> nodeTypeDefinitions, NodeTypeDefinitionProvider ntDefinitionProvider, NamespaceResolver nsResolver, Writer writer) throws IOException, RepositoryException {
        CompactNodeTypeDefWriter cndWriter = new CompactNodeTypeDefWriter(writer, nsResolver, true);
        HashSet<Name> written = new HashSet<Name>();
        int numWrittenNodeTypes = 0;
        for (QNodeTypeDefinition qNodeTypeDefinition : nodeTypeDefinitions) {
            numWrittenNodeTypes += this.writeNodeType(qNodeTypeDefinition, cndWriter, written, ntDefinitionProvider);
        }
        cndWriter.close();
        return numWrittenNodeTypes;
    }

    private int writeNodeType(Name nodeType, CompactNodeTypeDefWriter cndWriter, Set<Name> written, NodeTypeDefinitionProvider ntDefinitionProvider) throws IOException, RepositoryException {
        if (nodeType == null || written.contains(nodeType)) {
            return 0;
        }
        QNodeTypeDefinition ntDefinition = ntDefinitionProvider.getNodeTypeDefinition(nodeType);
        return this.writeNodeType(ntDefinition, cndWriter, written, ntDefinitionProvider);
    }

    private int writeNodeType(QNodeTypeDefinition ntDefinition, CompactNodeTypeDefWriter cndWriter, Set<Name> written, NodeTypeDefinitionProvider ntDefinitionProvider) throws IOException, RepositoryException {
        int numWrittenNodeTypes = 1;
        cndWriter.write(ntDefinition);
        written.add(ntDefinition.getName());
        for (Name name : ntDefinition.getSupertypes()) {
            numWrittenNodeTypes += this.writeNodeType(name, cndWriter, written, ntDefinitionProvider);
        }
        for (Name name : ntDefinition.getChildNodeDefs()) {
            this.writeNodeType(name.getDefaultPrimaryType(), cndWriter, written, ntDefinitionProvider);
            if (name.getRequiredPrimaryTypes() == null) continue;
            for (Name name2 : name.getRequiredPrimaryTypes()) {
                numWrittenNodeTypes += this.writeNodeType(name2, cndWriter, written, ntDefinitionProvider);
            }
        }
        return numWrittenNodeTypes;
    }

    final class NodeTypeCollectorHandler
    implements DocViewParserHandler {
        private final Set<String> nodeTypes;
        private Path file;

        public NodeTypeCollectorHandler(Set<String> nodeTypes) {
            this.nodeTypes = nodeTypes;
        }

        public void setFile(Path file) {
            this.file = file;
        }

        public void startDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
            Optional primaryType = docViewNode.getPrimaryType();
            if (primaryType.isPresent() && this.nodeTypes.add((String)primaryType.get())) {
                GenerateCndMojo.this.getLog().debug((CharSequence)("Found primary type " + (String)primaryType.get() + " in node '" + nodePath + "' contained in file " + GenerateCndMojo.this.getProjectRelativeFilePath(this.file.toFile())));
            }
            if (this.nodeTypes.addAll(docViewNode.getMixinTypes())) {
                GenerateCndMojo.this.getLog().debug((CharSequence)("Found mixin types " + docViewNode.getMixinTypes() + " in node '" + nodePath + "' contained in file " + GenerateCndMojo.this.getProjectRelativeFilePath(this.file.toFile())));
            }
        }

        public void endDocViewNode(@NotNull String nodePath, @NotNull DocViewNode2 docViewNode, @NotNull Optional<DocViewNode2> parentDocViewNode, int line, int column) throws IOException, RepositoryException {
        }
    }
}

