/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.MavenBasedPackageDependency;
import org.apache.jackrabbit.filevault.maven.packaging.ValidatorSettings;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DependencyResolver;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ValidationMessagePrinter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageInfo;
import org.apache.jackrabbit.vault.validation.ValidationExecutorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractValidateMojo
extends AbstractMojo {
    public static final String IGNORE_GAV = "ignore";
    @Parameter(property="vault.skipValidation", defaultValue="false", required=true)
    boolean skipValidation;
    @Parameter
    private Map<String, ValidatorSettings> validatorsSettings;
    @Deprecated
    @Parameter(property="vault.failOnDependencyErrors", defaultValue="true")
    private boolean failOnDependencyErrors;
    @Parameter(defaultValue="${project}", readonly=true, required=false)
    protected MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=false)
    protected MavenSession session;
    @Parameter(property="vault.failOnValidationWarning", defaultValue="false")
    protected boolean failOnValidationWarnings;
    @Parameter(property="vault.dependencies")
    protected Collection<MavenBasedPackageDependency> dependencies = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.repository.structure.packages")
    protected Collection<MavenBasedPackageDependency> repositoryStructurePackages = new LinkedList<MavenBasedPackageDependency>();
    @Parameter(property="vault.package.dependency.to.maven.ga")
    protected Collection<String> mapPackageDependencyToMavenGa;
    @Parameter(property="vault.validation.csvReportFile")
    protected File csvReportFile;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    protected final ValidationExecutorFactory validationExecutorFactory = new ValidationExecutorFactory(((Object)((Object)this)).getClass().getClassLoader());
    protected DependencyResolver resolver;
    protected final RepositorySystem repositorySystem;
    protected final BuildContext buildContext;
    public static final Artifact IGNORE_ARTIFACT = new DefaultArtifact("ignore", "ignore", null, null);

    @Inject
    protected AbstractValidateMojo(RepositorySystem repositorySystem, BuildContext buildContext) {
        this.repositorySystem = repositorySystem;
        this.buildContext = buildContext;
    }

    protected String getProjectRelativeFilePath(Path path) {
        Path baseDir = this.project != null && this.project.getBasedir() != null ? this.project.getBasedir().toPath() : null;
        return AbstractValidateMojo.getRelativeFilePath(path, baseDir);
    }

    public static String getRelativeFilePath(@NotNull Path path, @Nullable Path baseDir) {
        Path shortenedPath = baseDir != null ? baseDir.relativize(path) : path;
        return "'" + shortenedPath.toString() + "'";
    }

    static Map<Dependency, Artifact> resolveMap(Collection<String> mapPackageDependencyToMavenGa) {
        return mapPackageDependencyToMavenGa.stream().map(s -> s.split("=", 2)).peek(p -> {
            if (((String[])p).length != 2) {
                throw new IllegalArgumentException("Could not parse value");
            }
        }).collect(Collectors.toMap(a -> Dependency.fromString((String)a[0]), a -> {
            if (a[1].equalsIgnoreCase(IGNORE_GAV)) {
                return IGNORE_ARTIFACT;
            }
            return AbstractValidateMojo.artifactWithZipExtensionAndNoVersion((Artifact)new DefaultArtifact(a[1] + ":artificialVersion"));
        }));
    }

    private static Artifact artifactWithZipExtensionAndNoVersion(Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), "zip", null);
    }

    protected boolean shouldSkip() {
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkip()) {
            return;
        }
        if (this.skipValidation) {
            this.getLog().info((CharSequence)"Skipping validation");
            return;
        }
        this.translateLegacyParametersToValidatorParameters();
        LinkedList<PackageInfo> resolvedDependencies = new LinkedList<PackageInfo>();
        try (ValidationMessagePrinter validationHelper = new ValidationMessagePrinter(this.getLog(), this.csvReportFile != null ? this.csvReportFile.toPath() : null);){
            if (this.project != null) {
                this.getLog().debug((CharSequence)("Clear markers in " + this.project.getBasedir()));
                validationHelper.clearPreviousValidationMessages(this.buildContext, this.project.getBasedir());
            }
            try {
                LinkedList<String> validRoots = new LinkedList<String>();
                for (PackageInfo packageInfo : this.getPackageInfoFromMavenBasedDependencies(this.repositoryStructurePackages)) {
                    for (PathFilterSet set : packageInfo.getFilter().getFilterSets()) {
                        validRoots.add(set.getRoot());
                    }
                }
                if (!validRoots.isEmpty()) {
                    ValidatorSettings settings = null;
                    if (this.validatorsSettings != null) {
                        settings = this.validatorsSettings.get("jackrabbit-filter");
                    } else {
                        this.validatorsSettings = new HashMap<String, ValidatorSettings>();
                    }
                    if (settings == null) {
                        settings = new ValidatorSettings();
                        settings.addOption("validRoots", StringUtils.join(validRoots, (String)","));
                        this.validatorsSettings.put("jackrabbit-filter", settings);
                    } else {
                        String oldValidRoots = settings.getOptions().get("validRoots");
                        settings.addOption("validRoots", oldValidRoots + "," + StringUtils.join(validRoots, (String)","));
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not get meta information for repositoryStructurePackages '" + StringUtils.join(this.repositoryStructurePackages, (String)",") + "': " + e.getMessage(), (Exception)e);
            }
            try {
                resolvedDependencies.addAll(this.getPackageInfoFromMavenBasedDependencies(this.dependencies));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not get meta information for dependencies '" + StringUtils.join(this.dependencies, (String)",") + "': " + e.getMessage(), (Exception)e);
            }
            this.resolver = new DependencyResolver(this.repoSession, this.repositorySystem, this.projectRepos, AbstractValidateMojo.resolveMap(this.mapPackageDependencyToMavenGa), resolvedDependencies, this.getLog());
            this.doExecute(validationHelper);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create/write to CSV File", (Exception)e);
        }
    }

    private Collection<PackageInfo> getPackageInfoFromMavenBasedDependencies(Collection<MavenBasedPackageDependency> dependencies) throws IOException {
        LinkedList<PackageInfo> packageInfos = new LinkedList<PackageInfo>();
        MavenBasedPackageDependency.resolve(this.project, this.getLog(), dependencies);
        for (MavenBasedPackageDependency dependency : dependencies) {
            if (dependency.getInfo() == null) continue;
            packageInfos.add(dependency.getInfo());
        }
        return packageInfos;
    }

    private void translateLegacyParametersToValidatorParameters() throws MojoExecutionException {
        if (!this.failOnDependencyErrors) {
            ValidatorSettings filterValidatorSettings;
            this.getLog().warn((CharSequence)"Deprecated parameter 'failOnDependencyErrors' used.");
            if (this.validatorsSettings != null) {
                if (this.validatorsSettings.containsKey("jackrabbit-dependencies")) {
                    throw new MojoExecutionException("Can not set parameters 'failOnDependencyErrors' and 'validationSettings' for 'jackrabbit-dependencies' at the same time");
                }
            } else {
                this.validatorsSettings = new HashMap<String, ValidatorSettings>();
            }
            ValidatorSettings dependencyValidatorSettings = new ValidatorSettings();
            dependencyValidatorSettings.setDefaultSeverity(ValidationMessageSeverity.DEBUG.name());
            this.validatorsSettings.put("jackrabbit-dependencies", dependencyValidatorSettings);
            ValidatorSettings validatorSettings = filterValidatorSettings = this.validatorsSettings.containsKey("jackrabbit-filter") ? this.validatorsSettings.get("jackrabbit-filter") : new ValidatorSettings();
            if (filterValidatorSettings.getOptions().containsKey("severityForUncoveredAncestorNodes")) {
                throw new MojoExecutionException("Can not set parameters 'failOnDependencyErrors' and 'validationSettings' for 'jackrabbit-dependencies' with option'severityForUncoveredAncestorNodes' at the same time");
            }
            filterValidatorSettings.addOption("severityForUncoveredAncestorNodes", ValidationMessageSeverity.DEBUG.toString().toLowerCase(Locale.ROOT));
        }
    }

    public abstract void doExecute(ValidationMessagePrinter var1) throws MojoExecutionException, MojoFailureException;

    protected Map<String, ValidatorSettings> getEffectiveValidatorSettingsForPackage(PackageId packageId, boolean isSubPackage) throws MojoFailureException {
        try {
            return AbstractValidateMojo.getEffectiveValidatorSettingsForPackage(this.validatorsSettings, packageId, isSubPackage);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid value for 'validatorsSettings': " + e.getMessage(), (Throwable)e);
        }
    }

    protected static Map<String, ValidatorSettings> getEffectiveValidatorSettingsForPackage(Map<String, ValidatorSettings> validatorsSettings, PackageId packageId, boolean isSubPackage) {
        if (validatorsSettings == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SortedSet> validatorSettingsById = new HashMap<String, SortedSet>();
        for (Map.Entry<String, ValidatorSettings> entry : validatorsSettings.entrySet()) {
            if (!entry.getValue().isApplicable(packageId, isSubPackage)) continue;
            String validatorId = entry.getKey().split("__")[0];
            SortedSet settings = validatorSettingsById.computeIfAbsent(validatorId, s -> new TreeSet());
            settings.add(entry.getValue());
        }
        HashMap<String, ValidatorSettings> effectiveValidatorSettingsById = new HashMap<String, ValidatorSettings>();
        for (Map.Entry entry : validatorSettingsById.entrySet()) {
            ValidatorSettings mergedSettings = null;
            for (ValidatorSettings settings : (SortedSet)entry.getValue()) {
                if (mergedSettings == null) {
                    mergedSettings = settings;
                    continue;
                }
                mergedSettings = mergedSettings.merge(settings);
            }
            effectiveValidatorSettingsById.put((String)entry.getKey(), mergedSettings);
        }
        return effectiveValidatorSettingsById;
    }

    static final class DotContentXmlFirstComparator
    implements Comparator<String> {
        DotContentXmlFirstComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (".content.xml".equals(s1) && ".content.xml".equals(s2)) {
                return 0;
            }
            if (".content.xml".equals(s1)) {
                return -1;
            }
            if (".content.xml".equals(s2)) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

