/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl.extensions;

import java.util.function.Consumer;
import javax.inject.Named;
import org.apache.jackrabbit.filevault.maven.packaging.InterpolatorCustomizerFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.ValueSource;

@Named
public class DocviewEscapingInterpolatorCustomizerFactory
extends AbstractValueSource
implements InterpolatorCustomizerFactory,
InterpolationPostProcessor {
    public static final String EXPRESSION_PREFIX = "vltattributeescape.";
    private static final Name DEFAULT_NAME = NameConstants.JCR_TITLE;

    public DocviewEscapingInterpolatorCustomizerFactory() {
        super(false);
    }

    public Object getValue(String expression) {
        if (expression.startsWith(EXPRESSION_PREFIX)) {
            return "${" + expression.substring(EXPRESSION_PREFIX.length()) + "}";
        }
        return null;
    }

    public Object execute(String expression, Object value) {
        if (expression.startsWith(EXPRESSION_PREFIX)) {
            String escapedValue = new DocViewProperty2(DEFAULT_NAME, value.toString()).formatValue();
            return Text.encodeIllegalXMLCharacters((String)escapedValue);
        }
        return null;
    }

    @Override
    public Consumer<Interpolator> create(MavenSession mavenSession, MavenProject mavenProject) {
        return i -> {
            i.addPostProcessor((InterpolationPostProcessor)this);
            i.addValueSource((ValueSource)this);
        };
    }
}

