/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

@Singleton
@Named(value="content-package")
public class ContentPackageLifecycleMappingProvider
implements Provider<LifecycleMapping> {
    private static final String DEFAULT_LIFECYCLE_KEY = "default";
    private static final Map<String, LifecyclePhase> BINDINGS = new HashMap<String, LifecyclePhase>();
    private final Lifecycle defaultLifecycle = new Lifecycle();
    private final LifecycleMapping lifecycleMapping;

    public ContentPackageLifecycleMappingProvider() {
        this.defaultLifecycle.setId(DEFAULT_LIFECYCLE_KEY);
        this.defaultLifecycle.setLifecyclePhases(BINDINGS);
        this.lifecycleMapping = new LifecycleMapping(){

            public Map<String, Lifecycle> getLifecycles() {
                return Collections.singletonMap(ContentPackageLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY, ContentPackageLifecycleMappingProvider.this.defaultLifecycle);
            }

            public List<String> getOptionalMojos(String lifecycle) {
                return null;
            }

            public Map<String, String> getPhases(String lifecycle) {
                if (ContentPackageLifecycleMappingProvider.DEFAULT_LIFECYCLE_KEY.equals(lifecycle)) {
                    return ContentPackageLifecycleMappingProvider.this.defaultLifecycle.getPhases();
                }
                return null;
            }
        };
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }

    static {
        BINDINGS.put("process-resources", new LifecyclePhase("org.apache.maven.plugins:maven-resources-plugin:3.2.0:resources"));
        BINDINGS.put("compile", new LifecyclePhase("org.apache.maven.plugins:maven-compiler-plugin:3.10.1:compile"));
        BINDINGS.put("generate-test-sources", new LifecyclePhase("org.apache.jackrabbit:filevault-package-maven-plugin:generate-metadata"));
        BINDINGS.put("process-test-sources", new LifecyclePhase("org.apache.jackrabbit:filevault-package-maven-plugin:validate-files"));
        BINDINGS.put("process-test-resources", new LifecyclePhase("org.apache.maven.plugins:maven-resources-plugin:3.2.0:testResources"));
        BINDINGS.put("test-compile", new LifecyclePhase("org.apache.maven.plugins:maven-compiler-plugin:3.10.1:testCompile"));
        BINDINGS.put("test", new LifecyclePhase("org.apache.maven.plugins:maven-surefire-plugin:2.22.2:test"));
        BINDINGS.put("package", new LifecyclePhase("org.apache.jackrabbit:filevault-package-maven-plugin:package"));
        BINDINGS.put("verify", new LifecyclePhase("org.apache.jackrabbit:filevault-package-maven-plugin:validate-package"));
        BINDINGS.put("install", new LifecyclePhase("org.apache.maven.plugins:maven-install-plugin:2.5.2:install"));
        BINDINGS.put("deploy", new LifecyclePhase("org.apache.maven.plugins:maven-deploy-plugin:2.8.2:deploy"));
    }
}

