/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf;

import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.customizer.analysis.AggregateFunctionAnalysis;
import org.apache.iotdb.udf.api.customizer.parameter.FunctionArguments;
import org.apache.iotdb.udf.api.exception.UDFArgumentNotValidException;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.ResultValue;

public class AggregateFunctionExample
implements AggregateFunction {
    public AggregateFunctionAnalysis analyze(FunctionArguments arguments) throws UDFArgumentNotValidException {
        if (arguments.getArgumentsSize() != 1) {
            throw new UDFArgumentNotValidException("Only one parameter is required.");
        }
        return new AggregateFunctionAnalysis.Builder().outputDataType(Type.INT64).removable(true).build();
    }

    public State createState() {
        return new CountState();
    }

    public void addInput(State state, Record input) {
        CountState countState = (CountState)state;
        if (!input.isNull(0)) {
            ++countState.count;
        }
    }

    public void combineState(State state, State rhs) {
        CountState countState = (CountState)state;
        CountState rhsCountState = (CountState)rhs;
        countState.count += rhsCountState.count;
    }

    public void outputFinal(State state, ResultValue resultValue) {
        CountState countState = (CountState)state;
        resultValue.setLong(countState.count);
    }

    public void remove(State state, Record input) {
        CountState countState = (CountState)state;
        if (!input.isNull(0)) {
            --countState.count;
        }
    }

    static class CountState
    implements State {
        long count;

        CountState() {
        }

        public void reset() {
            this.count = 0L;
        }

        public byte[] serialize() {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(this.count);
            return buffer.array();
        }

        public void deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.count = buffer.getLong();
        }
    }
}

