/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.opcua;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.opcua.ClientExample;
import org.apache.iotdb.opcua.IoTDBKeyStoreLoaderClient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.client.security.DefaultClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.slf4j.LoggerFactory;

public class ClientExampleRunner {
    private final CompletableFuture<OpcUaClient> future = new CompletableFuture();
    private final ClientExample clientExample;

    public ClientExampleRunner(ClientExample clientExample) {
        this.clientExample = clientExample;
    }

    private OpcUaClient createClient() throws Exception {
        Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "client", "security");
        Files.createDirectories(securityTempDir, new FileAttribute[0]);
        if (!Files.exists(securityTempDir, new LinkOption[0])) {
            throw new Exception("unable to create security dir: " + securityTempDir);
        }
        File pkiDir = securityTempDir.resolve("pki").toFile();
        System.out.println("security dir: " + securityTempDir.toAbsolutePath());
        LoggerFactory.getLogger(this.getClass()).info("security pki dir: {}", (Object)pkiDir.getAbsolutePath());
        IoTDBKeyStoreLoaderClient loader = new IoTDBKeyStoreLoaderClient().load(securityTempDir);
        DefaultTrustListManager trustListManager = new DefaultTrustListManager(pkiDir);
        DefaultClientCertificateValidator certificateValidator = new DefaultClientCertificateValidator((TrustListManager)trustListManager);
        return OpcUaClient.create((String)this.clientExample.getEndpointUrl(), endpoints -> endpoints.stream().filter(this.clientExample.endpointFilter()).findFirst(), configBuilder -> configBuilder.setApplicationName(LocalizedText.english((String)"eclipse milo opc-ua client")).setApplicationUri("urn:eclipse:milo:examples:client").setKeyPair(loader.getClientKeyPair()).setCertificate(loader.getClientCertificate()).setCertificateChain(loader.getClientCertificateChain()).setCertificateValidator((ClientCertificateValidator)certificateValidator).setIdentityProvider(this.clientExample.getIdentityProvider()).setRequestTimeout(Unsigned.uint((int)5000)).build());
    }

    public void run() {
        try {
            OpcUaClient client = this.createClient();
            this.future.whenCompleteAsync((c, ex) -> {
                if (ex != null) {
                    System.out.println("Error running example: " + ex.getMessage());
                }
                try {
                    client.disconnect().get();
                    Stack.releaseSharedResources();
                }
                catch (InterruptedException | ExecutionException e) {
                    Thread.currentThread().interrupt();
                    System.out.println("Error disconnecting: {}" + e.getMessage());
                }
                try {
                    Thread.sleep(1000L);
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace();
                }
            });
            try {
                this.clientExample.run(client, this.future);
                this.future.get(100000L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                System.out.println("Error running client example: " + t.getMessage() + t);
                this.future.completeExceptionally(t);
            }
        }
        catch (Throwable t) {
            System.out.println("Error getting client: {}" + t.getMessage());
            this.future.completeExceptionally(t);
            try {
                Thread.sleep(1000L);
                System.exit(0);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(999999999L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

