/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.opcua;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.opcua.ClientExample;
import org.apache.iotdb.opcua.ClientExampleRunner;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

public class ClientTest
implements ClientExample {
    private final AtomicLong clientHandles = new AtomicLong(1L);

    public static void main(String[] args) {
        ClientTest example = new ClientTest();
        new ClientExampleRunner(example).run();
    }

    @Override
    public void run(OpcUaClient client, CompletableFuture<OpcUaClient> future) throws Exception {
        client.connect().get();
        UaSubscription subscription = (UaSubscription)client.getSubscriptionManager().createSubscription(200.0).get();
        ReadValueId readValueId = new ReadValueId(Identifiers.Server, AttributeId.EventNotifier.uid(), null, QualifiedName.NULL_VALUE);
        UInteger clientHandle = Unsigned.uint((long)this.clientHandles.getAndIncrement());
        EventFilter eventFilter = new EventFilter(new SimpleAttributeOperand[]{new SimpleAttributeOperand(Identifiers.BaseEventType, new QualifiedName[]{new QualifiedName(0, "Time")}, AttributeId.Value.uid(), null), new SimpleAttributeOperand(Identifiers.BaseEventType, new QualifiedName[]{new QualifiedName(0, "Message")}, AttributeId.Value.uid(), null), new SimpleAttributeOperand(Identifiers.BaseEventType, new QualifiedName[]{new QualifiedName(0, "SourceName")}, AttributeId.Value.uid(), null), new SimpleAttributeOperand(Identifiers.BaseEventType, new QualifiedName[]{new QualifiedName(0, "SourceNode")}, AttributeId.Value.uid(), null)}, new ContentFilter(null));
        MonitoringParameters parameters = new MonitoringParameters(clientHandle, Double.valueOf(0.0), ExtensionObject.encode((SerializationContext)client.getStaticSerializationContext(), (UaStructure)eventFilter), Unsigned.uint((int)10000), Boolean.valueOf(true));
        MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
        List items = (List)subscription.createMonitoredItems(TimestampsToReturn.Both, Collections.singletonList(request)).get();
        UaMonitoredItem monitoredItem = (UaMonitoredItem)items.get(0);
        AtomicInteger eventCount = new AtomicInteger(0);
        monitoredItem.setEventConsumer((item, vs) -> {
            eventCount.incrementAndGet();
            System.out.println("Event Received from " + item.getReadValueId().getNodeId());
            for (int i = 0; i < vs.length; ++i) {
                System.out.println("\tvariant[" + i + "]: " + vs[i].getValue());
            }
        });
    }
}

