/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class CountPointProcessor
implements PipeProcessor {
    private static final String AGGREGATE_SERIES_KEY = "aggregate-series";
    private static final AtomicLong writePointCount = new AtomicLong(0L);
    private PartialPath aggregateSeries;

    public void validate(PipeParameterValidator validator) {
        validator.validateRequiredAttribute(AGGREGATE_SERIES_KEY);
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        this.aggregateSeries = new PartialPath(parameters.getString(AGGREGATE_SERIES_KEY));
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) {
        tabletInsertionEvent.processTablet((tablet, rowCollector) -> writePointCount.addAndGet(tablet.rowSize));
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        if (event instanceof PipeHeartbeatEvent) {
            Tablet tablet = new Tablet(this.aggregateSeries.getDevice(), Collections.singletonList(new MeasurementSchema(this.aggregateSeries.getMeasurement(), TSDataType.INT64)), 1);
            tablet.rowSize = 1;
            tablet.addTimestamp(0, System.currentTimeMillis());
            tablet.addValue(this.aggregateSeries.getMeasurement(), 0, (Object)writePointCount.get());
            eventCollector.collect((Event)new PipeRawTabletInsertionEvent(tablet, false, null, 0L, null, null, false));
        }
    }

    public void close() {
    }
}

