/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor.hash;

import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.tsfile.file.metadata.IDeviceID;

public class JSHashExecutor
extends SeriesPartitionExecutor {
    private static final int BASE = 1315423911;

    public JSHashExecutor(int deviceGroupCount) {
        super(deviceGroupCount);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(String device) {
        int hash = 1315423911;
        for (int i = 0; i < device.length(); ++i) {
            hash ^= (hash << 5) + device.charAt(i) + (hash >> 2);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(IDeviceID deviceID) {
        int hash = 1315423911;
        int segmentNum = deviceID.segmentNum();
        for (int segmentID = 0; segmentID < segmentNum; ++segmentID) {
            Object segment = deviceID.segment(segmentID);
            if (segment instanceof String) {
                String segmentStr = (String)segment;
                for (int i = 0; i < segmentStr.length(); ++i) {
                    hash ^= (hash << 5) + segmentStr.charAt(i) + (hash >> 2);
                }
            } else {
                hash ^= (hash << 5) + 65536 + (hash >> 2);
            }
            if (segmentID >= segmentNum - 1) continue;
            hash ^= (hash << 5) + 46 + (hash >> 2);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }
}

