/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.ConfigurationFileUtils;
import org.apache.iotdb.commons.conf.TrimProperties;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.pipe.config.PipeDescriptor;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDescriptor.class);
    private final CommonConfig config = new CommonConfig();

    private CommonDescriptor() {
    }

    public static CommonDescriptor getInstance() {
        return CommonDescriptorHolder.INSTANCE;
    }

    public CommonConfig getConfig() {
        return this.config;
    }

    public String getConfDir() {
        String confString = System.getProperty("IOTDB_CONF", null);
        if (confString == null && (confString = System.getProperty("IOTDB_HOME", null)) != null) {
            confString = confString + File.separatorChar + "conf";
        }
        return confString;
    }

    public void initCommonConfigDir(String systemDir) {
        this.config.setUserFolder(systemDir + File.separator + "users");
        this.config.setRoleFolder(systemDir + File.separator + "roles");
        this.config.setProcedureWalFolder(systemDir + File.separator + "procedure");
    }

    public void loadCommonProps(TrimProperties properties) throws IOException {
        this.config.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.config.getAuthorizerProvider()).trim());
        this.config.setOpenIdProviderUrl(properties.getProperty("openID_url", this.config.getOpenIdProviderUrl()).trim());
        this.config.setEncryptDecryptProvider(properties.getProperty("iotdb_server_encrypt_decrypt_provider", this.config.getEncryptDecryptProvider()).trim());
        this.config.setEncryptDecryptProviderParameter(properties.getProperty("iotdb_server_encrypt_decrypt_provider_parameter", this.config.getEncryptDecryptProviderParameter()));
        CharSequence[] tierTTLStr = new String[this.config.getTierTTLInMs().length];
        for (int i = 0; i < tierTTLStr.length; ++i) {
            tierTTLStr[i] = String.valueOf(this.config.getTierTTLInMs()[i]);
        }
        tierTTLStr = properties.getProperty("tier_ttl_in_ms", String.join((CharSequence)";", tierTTLStr)).split(";");
        long[] tierTTL = new long[tierTTLStr.length];
        for (int i = 0; i < tierTTL.length; ++i) {
            tierTTL[i] = Long.parseLong((String)tierTTLStr[i]);
            if (tierTTL[i] >= 0L) continue;
            tierTTL[i] = Long.MAX_VALUE;
        }
        this.config.setTierTTLInMs(tierTTL);
        this.config.setTTLCheckInterval(Long.parseLong(properties.getProperty("ttl_check_interval", Long.toString(this.config.getTTLCheckInterval()))));
        this.config.setSyncDir(properties.getProperty("dn_sync_dir", this.config.getSyncDir()).trim());
        this.config.setWalDirs(properties.getProperty("dn_wal_dirs", String.join((CharSequence)",", this.config.getWalDirs())).trim().split(","));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("cn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setCnConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("cn_connection_timeout_ms", String.valueOf(this.config.getCnConnectionTimeoutInMS())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("cn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setDnConnectionTimeoutInMS(Integer.parseInt(properties.getProperty("dn_connection_timeout_ms", String.valueOf(this.config.getDnConnectionTimeoutInMS())).trim()));
        this.config.setRpcThriftCompressionEnabled(Boolean.parseBoolean(properties.getProperty("dn_rpc_thrift_compression_enable", String.valueOf(this.config.isRpcThriftCompressionEnabled())).trim()));
        this.config.setSelectorNumOfClientManager(Integer.parseInt(properties.getProperty("dn_selector_thread_nums_of_client_manager", String.valueOf(this.config.getSelectorNumOfClientManager())).trim()));
        this.config.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("dn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.config.getMaxClientNumForEachNode())).trim()));
        this.config.setHandleSystemErrorStrategy(HandleSystemErrorStrategy.valueOf(properties.getProperty("handle_system_error", String.valueOf((Object)this.config.getHandleSystemErrorStrategy())).trim()));
        this.config.setDiskSpaceWarningThreshold(Double.parseDouble(properties.getProperty("disk_space_warning_threshold", String.valueOf(this.config.getDiskSpaceWarningThreshold())).trim()));
        this.config.setTimestampPrecision(properties.getProperty("timestamp_precision", this.config.getTimestampPrecision()).trim());
        this.config.setTimestampPrecisionCheckEnabled(Boolean.parseBoolean(properties.getProperty("timestamp_precision_check_enabled", String.valueOf(this.config.isTimestampPrecisionCheckEnabled()))));
        this.config.setDatanodeTokenTimeoutMS(Integer.parseInt(properties.getProperty("datanode_token_timeout", String.valueOf(180000))));
        PipeDescriptor.loadPipeProps(this.config, properties, false);
        this.loadSubscriptionProps(properties);
        this.config.setSchemaEngineMode(properties.getProperty("schema_engine_mode", String.valueOf(this.config.getSchemaEngineMode())));
        this.config.setLastCacheEnable(Boolean.parseBoolean(properties.getProperty("enable_last_cache", Boolean.toString(this.config.isLastCacheEnable()))));
        this.config.setTagAttributeTotalSize(Integer.parseInt(properties.getProperty("tag_attribute_total_size", String.valueOf(this.config.getTagAttributeTotalSize()))));
        this.config.setTimePartitionOrigin(Long.parseLong(properties.getProperty("time_partition_origin", String.valueOf(this.config.getTimePartitionOrigin()))));
        this.config.setTimePartitionInterval(Long.parseLong(properties.getProperty("time_partition_interval", String.valueOf(this.config.getTimePartitionInterval()))));
        this.config.setDatabaseLimitThreshold(Integer.parseInt(properties.getProperty("database_limit_threshold", String.valueOf(this.config.getDatabaseLimitThreshold()))));
        this.config.setSeriesLimitThreshold(Long.parseLong(properties.getProperty("cluster_timeseries_limit_threshold", String.valueOf(this.config.getSeriesLimitThreshold()))));
        this.config.setDeviceLimitThreshold(Long.parseLong(properties.getProperty("cluster_device_limit_threshold", String.valueOf(this.config.getDeviceLimitThreshold()))));
        this.loadRetryProperties(properties);
        this.loadBinaryAllocatorProps(properties);
    }

    private void loadSubscriptionProps(TrimProperties properties) {
        this.config.setSubscriptionCacheMemoryUsagePercentage(Float.parseFloat(properties.getProperty("subscription_cache_memory_usage_percentage", String.valueOf(this.config.getSubscriptionCacheMemoryUsagePercentage()))));
        this.config.setSubscriptionSubtaskExecutorMaxThreadNum(Integer.parseInt(properties.getProperty("subscription_subtask_executor_max_thread_num", Integer.toString(this.config.getSubscriptionSubtaskExecutorMaxThreadNum()))));
        this.config.setSubscriptionPrefetchTabletBatchMaxDelayInMs(Integer.parseInt(properties.getProperty("subscription_prefetch_tablet_batch_max_delay_in_ms", String.valueOf(this.config.getSubscriptionPrefetchTabletBatchMaxDelayInMs()))));
        this.config.setSubscriptionPrefetchTabletBatchMaxSizeInBytes(Long.parseLong(properties.getProperty("subscription_prefetch_tablet_batch_max_size_in_bytes", String.valueOf(this.config.getSubscriptionPrefetchTabletBatchMaxSizeInBytes()))));
        this.config.setSubscriptionPrefetchTsFileBatchMaxDelayInMs(Integer.parseInt(properties.getProperty("subscription_prefetch_ts_file_batch_max_delay_in_ms", String.valueOf(this.config.getSubscriptionPrefetchTsFileBatchMaxDelayInMs()))));
        this.config.setSubscriptionPrefetchTsFileBatchMaxSizeInBytes(Long.parseLong(properties.getProperty("subscription_prefetch_ts_file_batch_max_size_in_bytes", String.valueOf(this.config.getSubscriptionPrefetchTsFileBatchMaxSizeInBytes()))));
        this.config.setSubscriptionPollMaxBlockingTimeMs(Integer.parseInt(properties.getProperty("subscription_poll_max_blocking_time_ms", String.valueOf(this.config.getSubscriptionPollMaxBlockingTimeMs()))));
        this.config.setSubscriptionDefaultTimeoutInMs(Integer.parseInt(properties.getProperty("subscription_default_timeout_in_ms", String.valueOf(this.config.getSubscriptionDefaultTimeoutInMs()))));
        this.config.setSubscriptionLaunchRetryIntervalMs(Long.parseLong(properties.getProperty("subscription_launch_retry_interval_ms", String.valueOf(this.config.getSubscriptionLaunchRetryIntervalMs()))));
        this.config.setSubscriptionRecycleUncommittedEventIntervalMs(Integer.parseInt(properties.getProperty("subscription_recycle_uncommitted_event_interval_ms", String.valueOf(this.config.getSubscriptionRecycleUncommittedEventIntervalMs()))));
        this.config.setSubscriptionReadFileBufferSize(Long.parseLong(properties.getProperty("subscription_read_file_buffer_size", String.valueOf(this.config.getSubscriptionReadFileBufferSize()))));
        this.config.setSubscriptionReadTabletBufferSize(Long.parseLong(properties.getProperty("subscription_read_tablet_buffer_size", String.valueOf(this.config.getSubscriptionReadTabletBufferSize()))));
        this.config.setSubscriptionTsFileDeduplicationWindowSeconds(Long.parseLong(properties.getProperty("subscription_ts_file_deduplication_window_seconds", String.valueOf(this.config.getSubscriptionTsFileDeduplicationWindowSeconds()))));
        this.config.setSubscriptionCheckMemoryEnoughIntervalMs(Long.parseLong(properties.getProperty("subscription_check_memory_enough_interval_ms", String.valueOf(this.config.getSubscriptionCheckMemoryEnoughIntervalMs()))));
        this.config.setSubscriptionEstimatedInsertNodeTabletInsertionEventSize(Long.parseLong(properties.getProperty("subscription_estimated_insert_node_tablet_insertion_event_size", String.valueOf(this.config.getSubscriptionEstimatedInsertNodeTabletInsertionEventSize()))));
        this.config.setSubscriptionEstimatedRawTabletInsertionEventSize(Long.parseLong(properties.getProperty("subscription_estimated_raw_tablet_insertion_event_size", String.valueOf(this.config.getSubscriptionEstimatedRawTabletInsertionEventSize()))));
        this.config.setSubscriptionMaxAllowedEventCountInTabletBatch(Long.parseLong(properties.getProperty("subscription_max_allowed_event_count_in_tablet_batch", String.valueOf(this.config.getSubscriptionMaxAllowedEventCountInTabletBatch()))));
        this.config.setSubscriptionLogManagerWindowSeconds(Long.parseLong(properties.getProperty("subscription_log_manager_window_seconds", String.valueOf(this.config.getSubscriptionLogManagerWindowSeconds()))));
        this.config.setSubscriptionLogManagerBaseIntervalMs(Long.parseLong(properties.getProperty("subscription_log_manager_base_interval_ms", String.valueOf(this.config.getSubscriptionLogManagerBaseIntervalMs()))));
        this.config.setSubscriptionPrefetchEnabled(Boolean.parseBoolean(properties.getProperty("subscription_prefetch_enabled", String.valueOf(this.config.getSubscriptionPrefetchEnabled()))));
        this.config.setSubscriptionPrefetchMemoryThreshold(Float.parseFloat(properties.getProperty("subscription_prefetch_memory_threshold", String.valueOf(this.config.getSubscriptionPrefetchMemoryThreshold()))));
        this.config.setSubscriptionPrefetchMissingRateThreshold(Float.parseFloat(properties.getProperty("subscription_prefetch_missing_rate_threshold", String.valueOf(this.config.getSubscriptionPrefetchMemoryThreshold()))));
        this.config.setSubscriptionPrefetchEventLocalCountThreshold(Integer.parseInt(properties.getProperty("subscription_prefetch_event_local_count_threshold", String.valueOf(this.config.getSubscriptionPrefetchEventLocalCountThreshold()))));
        this.config.setSubscriptionPrefetchEventGlobalCountThreshold(Integer.parseInt(properties.getProperty("subscription_prefetch_event_global_count_threshold", String.valueOf(this.config.getSubscriptionPrefetchEventGlobalCountThreshold()))));
        this.config.setSubscriptionMetaSyncerInitialSyncDelayMinutes(Long.parseLong(properties.getProperty("subscription_meta_syncer_initial_sync_delay_minutes", String.valueOf(this.config.getSubscriptionMetaSyncerInitialSyncDelayMinutes()))));
        this.config.setSubscriptionMetaSyncerSyncIntervalMinutes(Long.parseLong(properties.getProperty("subscription_meta_syncer_sync_interval_minutes", String.valueOf(this.config.getSubscriptionMetaSyncerSyncIntervalMinutes()))));
    }

    public void loadRetryProperties(TrimProperties properties) throws IOException {
        this.config.setRemoteWriteMaxRetryDurationInMs(Long.parseLong(properties.getProperty("write_request_remote_dispatch_max_retry_duration_in_ms", ConfigurationFileUtils.getConfigurationDefaultValue("write_request_remote_dispatch_max_retry_duration_in_ms"))));
        this.config.setRetryForUnknownErrors(Boolean.parseBoolean(properties.getProperty("enable_retry_for_unknown_error", ConfigurationFileUtils.getConfigurationDefaultValue("enable_retry_for_unknown_error"))));
    }

    public void loadBinaryAllocatorProps(TrimProperties properties) {
        this.config.setEnableBinaryAllocator(Boolean.parseBoolean(properties.getProperty("enable_binary_allocator", Boolean.toString(this.config.isEnableBinaryAllocator()))));
        this.config.setMinAllocateSize(Integer.parseInt(properties.getProperty("small_blob_object", String.valueOf(this.config.getMinAllocateSize()))));
        this.config.setMaxAllocateSize(Integer.parseInt(properties.getProperty("huge_blob_object", String.valueOf(this.config.getMaxAllocateSize()))));
        int arenaNum = Integer.parseInt(properties.getProperty("arena_num", String.valueOf(this.config.getArenaNum())));
        if (arenaNum > 0) {
            this.config.setArenaNum(arenaNum);
        }
        this.config.setLog2SizeClassGroup(Integer.parseInt(properties.getProperty("log2_size_class_group", String.valueOf(this.config.getLog2SizeClassGroup()))));
    }

    public void loadGlobalConfig(TGlobalConfig globalConfig) {
        this.config.setTimestampPrecision(globalConfig.timestampPrecision);
        this.config.setTimePartitionOrigin(CommonDateTimeUtils.convertMilliTimeWithPrecision(globalConfig.timePartitionOrigin, this.config.getTimestampPrecision()));
        this.config.setTimePartitionInterval(CommonDateTimeUtils.convertMilliTimeWithPrecision(globalConfig.timePartitionInterval, this.config.getTimestampPrecision()));
        this.config.setSchemaEngineMode(globalConfig.schemaEngineMode);
        this.config.setTagAttributeTotalSize(globalConfig.tagAttributeTotalSize);
        this.config.setDiskSpaceWarningThreshold(globalConfig.getDiskSpaceWarningThreshold());
    }

    private static class CommonDescriptorHolder {
        private static final CommonDescriptor INSTANCE = new CommonDescriptor();

        private CommonDescriptorHolder() {
        }
    }
}

