/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.path.ExtendedPartialPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.impl.StringValueFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;

public class DeviceFilterUtil {
    private DeviceFilterUtil() {
    }

    public static List<PartialPath> convertToDevicePattern(String database, String tableName, int idColumnNum, List<List<SchemaFilter>> idDeterminedFilterList) {
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        int length = idColumnNum + 3;
        for (List<SchemaFilter> idFilterList : idDeterminedFilterList) {
            Object[] nodes = new String[length];
            Arrays.fill(nodes, "*");
            nodes[0] = "root";
            nodes[1] = database;
            nodes[2] = tableName;
            ExtendedPartialPath partialPath = new ExtendedPartialPath((String[])nodes);
            for (SchemaFilter schemaFilter : idFilterList) {
                if (schemaFilter.getSchemaFilterType().equals((Object)SchemaFilterType.ID)) {
                    int index = ((IdFilter)schemaFilter).getIndex() + 3;
                    SchemaFilter childFilter = ((IdFilter)schemaFilter).getChild();
                    if (childFilter.getSchemaFilterType().equals((Object)SchemaFilterType.PRECISE)) {
                        nodes[index] = ((PreciseFilter)childFilter).getValue();
                        continue;
                    }
                    partialPath.addMatchFunction(index, node -> Boolean.TRUE.equals(childFilter.accept(StringValueFilterVisitor.getInstance(), node)));
                    continue;
                }
                throw new IllegalStateException("Input single filter must be DeviceIdFilter");
            }
            pathList.add(partialPath);
        }
        return pathList;
    }
}

