/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModelJDBCExample {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableModelJDBCExample.class);

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        ResultSetMetaData metaData;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667?sql_dialect=table", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("CREATE DATABASE test1");
                    statement.execute("CREATE DATABASE test2");
                    statement.execute("use test2");
                    statement.execute("create table test1.table1(region_id STRING TAG, plant_id STRING TAG, device_id STRING TAG, model STRING ATTRIBUTE, temperature FLOAT FIELD, humidity DOUBLE FIELD) with (TTL=3600000)");
                    statement.execute("create table table2(region_id STRING TAG, plant_id STRING TAG, color STRING ATTRIBUTE, temperature FLOAT FIELD, speed DOUBLE FIELD) with (TTL=6600000)");
                    resultSet = statement.executeQuery("SHOW TABLES");
                    try {
                        metaData = resultSet.getMetaData();
                        System.out.println(metaData.getColumnCount());
                        while (resultSet.next()) {
                            System.out.println(resultSet.getString(1) + ", " + resultSet.getInt(2));
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    resultSet = statement.executeQuery("SHOW TABLES FROM test1");
                    try {
                        metaData = resultSet.getMetaData();
                        System.out.println(metaData.getColumnCount());
                        while (resultSet.next()) {
                            System.out.println(resultSet.getString(1) + ", " + resultSet.getInt(2));
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (IoTDBSQLException e) {
            LOGGER.error("IoTDB Jdbc example error", (Throwable)e);
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/test1?sql_dialect=table", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("SHOW TABLES");
                try {
                    metaData = resultSet.getMetaData();
                    System.out.println(metaData.getColumnCount());
                    while (resultSet.next()) {
                        System.out.println(resultSet.getString(1) + ", " + resultSet.getInt(2));
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                statement.execute("use test2");
                resultSet = statement.executeQuery("SHOW TABLES");
                try {
                    metaData = resultSet.getMetaData();
                    System.out.println(metaData.getColumnCount());
                    while (resultSet.next()) {
                        System.out.println(resultSet.getString(1) + ", " + resultSet.getInt(2));
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

