/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.iotdb.jdbc.IoTDBSQLException;

public class SyntaxConventionRelatedExample {
    private static final String ROOT_SG1_KEYWORD_EXAMPLE = "root.sg1.select";
    private static final String ROOT_SG1_DIGITS_EXAMPLE = "root.sg1.`111`";
    private static final String ROOT_SG1_SPECIAL_CHARACTER_EXAMPLE = "root.sg1.`a\"b'c```";
    private static final String ROOT_SG1_NORMAL_NODE_EXAMPLE = "root.sg1.a";
    public static final String CREATE = "CREATE TIMESERIES %s WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY";
    private static final String DEVICE = "root.sg1";

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667?version=V_1_0", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(10000);
            statement.execute(String.format("CREATE DATABASE %s", DEVICE));
            statement.execute(String.format(CREATE, ROOT_SG1_DIGITS_EXAMPLE));
            statement.execute(String.format(CREATE, ROOT_SG1_KEYWORD_EXAMPLE));
            statement.execute(String.format(CREATE, ROOT_SG1_NORMAL_NODE_EXAMPLE));
            statement.execute(String.format(CREATE, ROOT_SG1_SPECIAL_CHARACTER_EXAMPLE));
            ResultSet resultSet = statement.executeQuery("show timeseries root.sg1.*");
            ArrayList<String> timeseriesList = new ArrayList<String>();
            while (resultSet.next()) {
                timeseriesList.add(resultSet.getString("Timeseries"));
            }
            for (String path : timeseriesList) {
                for (int i = 0; i <= 10; ++i) {
                    statement.addBatch(SyntaxConventionRelatedExample.prepareInsertStatement(i, path));
                }
            }
            statement.executeBatch();
            statement.clearBatch();
            resultSet = statement.executeQuery("select ** from root.sg1 where time <= 10");
            SyntaxConventionRelatedExample.outputResult(resultSet);
            for (String path : timeseriesList) {
                resultSet = statement.executeQuery(String.format("select %s from root.sg1", SyntaxConventionRelatedExample.removeDevice(path)));
                SyntaxConventionRelatedExample.outputResult(resultSet);
            }
        }
        catch (IoTDBSQLException e) {
            e.printStackTrace();
        }
    }

    private static void outputResult(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            int i;
            System.out.println("--------------------------");
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                System.out.print(metaData.getColumnLabel(i + 1) + " ");
            }
            System.out.println();
            block1: while (resultSet.next()) {
                i = 1;
                while (true) {
                    System.out.print(resultSet.getString(i));
                    if (i >= columnCount) {
                        System.out.println();
                        continue block1;
                    }
                    System.out.print(", ");
                    ++i;
                }
            }
            System.out.println("--------------------------\n");
        }
    }

    private static String prepareInsertStatement(int time, String path) {
        path = SyntaxConventionRelatedExample.removeDevice(path);
        return String.format("insert into root.sg1(timestamp, %s) values( %d ,1)", path, time);
    }

    private static String removeDevice(String path) {
        return path.substring(DEVICE.length() + 1);
    }
}

