/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer.base;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.rpc.subscription.config.ConsumerConstant;
import org.apache.iotdb.session.subscription.consumer.ISubscriptionTablePullConsumer;
import org.apache.iotdb.session.subscription.consumer.ISubscriptionTablePushConsumer;
import org.apache.iotdb.session.subscription.consumer.ISubscriptionTreePullConsumer;
import org.apache.iotdb.session.subscription.consumer.ISubscriptionTreePushConsumer;
import org.apache.iotdb.session.subscription.util.IdentifierUtils;
import org.apache.thrift.annotation.Nullable;

public class AbstractSubscriptionConsumerBuilder {
    protected String host;
    protected Integer port;
    protected List<String> nodeUrls;
    protected String username = "root";
    protected String password = "root";
    protected String consumerId;
    protected String consumerGroupId;
    protected long heartbeatIntervalMs = 30000L;
    protected long endpointsSyncIntervalMs = 120000L;
    protected String fileSaveDir = ConsumerConstant.FILE_SAVE_DIR_DEFAULT_VALUE;
    protected boolean fileSaveFsync = false;
    protected int thriftMaxFrameSize = 0x4000000;
    protected int maxPollParallelism = 1;

    public AbstractSubscriptionConsumerBuilder host(String host) {
        this.host = host;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder port(Integer port) {
        this.port = port;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder nodeUrls(List<String> nodeUrls) {
        this.nodeUrls = nodeUrls;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder username(String username) {
        this.username = username;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder password(String password) {
        this.password = password;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder consumerId(@Nullable String consumerId) {
        if (Objects.isNull(consumerId)) {
            return this;
        }
        this.consumerId = IdentifierUtils.checkAndParseIdentifier(consumerId);
        return this;
    }

    public AbstractSubscriptionConsumerBuilder consumerGroupId(@Nullable String consumerGroupId) {
        if (Objects.isNull(consumerGroupId)) {
            return this;
        }
        this.consumerGroupId = IdentifierUtils.checkAndParseIdentifier(consumerGroupId);
        return this;
    }

    public AbstractSubscriptionConsumerBuilder heartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = Math.max(heartbeatIntervalMs, 1000L);
        return this;
    }

    public AbstractSubscriptionConsumerBuilder endpointsSyncIntervalMs(long endpointsSyncIntervalMs) {
        this.endpointsSyncIntervalMs = Math.max(endpointsSyncIntervalMs, 5000L);
        return this;
    }

    public AbstractSubscriptionConsumerBuilder fileSaveDir(String fileSaveDir) {
        this.fileSaveDir = fileSaveDir;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder fileSaveFsync(boolean fileSaveFsync) {
        this.fileSaveFsync = fileSaveFsync;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder thriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        return this;
    }

    public AbstractSubscriptionConsumerBuilder maxPollParallelism(int maxPollParallelism) {
        this.maxPollParallelism = Math.max(maxPollParallelism, 1);
        return this;
    }

    public ISubscriptionTreePullConsumer buildPullConsumer() {
        throw new UnsupportedOperationException();
    }

    public ISubscriptionTreePushConsumer buildPushConsumer() {
        throw new UnsupportedOperationException();
    }

    public ISubscriptionTablePullConsumer buildTablePullConsumer() {
        throw new UnsupportedOperationException();
    }

    public ISubscriptionTablePushConsumer buildTablePushConsumer() {
        throw new UnsupportedOperationException();
    }
}

