/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.memory;

import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;

public class MemTableManager {
    private int currentMemtableNumber = 0;

    private MemTableManager() {
    }

    public static MemTableManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public synchronized IMemTable getAvailableMemTable(String storageGroup, String dataRegionId) {
        ++this.currentMemtableNumber;
        return new PrimitiveMemTable(storageGroup, dataRegionId);
    }

    public int getCurrentMemtableNumber() {
        return this.currentMemtableNumber;
    }

    public synchronized void decreaseMemtableNumber() {
        --this.currentMemtableNumber;
        this.notifyAll();
    }

    public synchronized void close() {
        this.currentMemtableNumber = 0;
    }

    private static class InstanceHolder {
        private static final MemTableManager INSTANCE = new MemTableManager();

        private InstanceHolder() {
        }
    }
}

