/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ISchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;

public class SchemaReaderLimitOffsetWrapper<T extends ISchemaInfo>
implements ISchemaReader<T> {
    private final ISchemaReader<T> schemaReader;
    private final long limit;
    private final long offset;
    private final boolean hasLimit;
    private int count = 0;
    private int curOffset = 0;
    private ListenableFuture<?> isBlocked = null;

    public SchemaReaderLimitOffsetWrapper(ISchemaReader<T> schemaReader, long limit, long offset) {
        this.schemaReader = schemaReader;
        this.limit = limit;
        this.offset = offset;
        this.hasLimit = limit > 0L || offset > 0L;
    }

    @Override
    public boolean isSuccess() {
        return this.schemaReader.isSuccess();
    }

    @Override
    public Throwable getFailure() {
        return this.schemaReader.getFailure();
    }

    @Override
    public void close() throws Exception {
        this.schemaReader.close();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked != null) {
            return this.isBlocked;
        }
        this.isBlocked = this.tryGetNext();
        return this.isBlocked;
    }

    private ListenableFuture<?> tryGetNext() {
        if (this.hasLimit) {
            if ((long)this.curOffset < this.offset) {
                return Futures.submit(() -> {
                    while ((long)this.curOffset < this.offset && this.schemaReader.hasNext()) {
                        this.schemaReader.next();
                        ++this.curOffset;
                    }
                    return this.schemaReader.hasNext();
                }, (Executor)MoreExecutors.directExecutor());
            }
            if ((long)this.count >= this.limit) {
                return NOT_BLOCKED;
            }
            return this.schemaReader.isBlocked();
        }
        return this.schemaReader.isBlocked();
    }

    @Override
    public boolean hasNext() {
        try {
            this.isBlocked().get();
            return this.schemaReader.hasNext() && (long)this.count < this.limit;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.schemaReader.next();
        if (this.hasLimit) {
            ++this.count;
        }
        return result;
    }
}

