/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final boolean distinct;
    private final List<Expression> arguments;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.distinct = false;
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(QualifiedName name, boolean distinct, List<Expression> arguments) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.distinct = distinct;
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public FunctionCall(NodeLocation location, QualifiedName name, List<Expression> arguments) {
        this(location, name, false, arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, boolean distinct, List<Expression> arguments) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.distinct = distinct;
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.arguments);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.distinct, o.distinct) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.arguments);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FunctionCall.sameClass(this, other)) {
            return false;
        }
        FunctionCall otherFunction = (FunctionCall)other;
        return this.name.equals(otherFunction.name) && this.distinct == otherFunction.distinct;
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.FUNCTION_CALL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.name.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.distinct, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.arguments.size(), (OutputStream)stream);
        for (Expression argument : this.arguments) {
            Expression.serialize(argument, stream);
        }
    }

    public FunctionCall(ByteBuffer byteBuffer) {
        super(null);
        this.name = QualifiedName.deserialize(byteBuffer);
        this.distinct = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.arguments = new ArrayList<Expression>(size);
        while (size-- > 0) {
            this.arguments.add(Expression.deserialize(byteBuffer));
        }
    }
}

